/*- 
 createCircleGraph - generates a circleGraph
 createCircle([n|Vertices] <,Directed|Undirected>) Default = Directed.
 createCircle([v1,..,vn]) generates a cycle with the edges [v1,v2], [v2,v3], ... , [v(n-1),vn], [vn,v1].

 Parameters:
    n - Number of vertices to be used.
    L - list (of vertices)
-*/
Graph::createCircleGraph := proc(L)
local _edges, i, _vertices, _directed;
begin
  if args(0) < 1 or args(0) > 2 then
    error("Wrong number of arguments!");
  end_if;
  if (not testtype(L, DOM_LIST)) and (not testtype(L, DOM_INT)) then
    error("Wrong argument type: list or positive integer expected!");
  end_if;
  
  _directed := hold(Directed);

  if args(0) = 2 then
    if args(2) = hold(Directed) then
      _directed := hold(Directed);
    elif args(2) = hold(Undirected) then
      _directed := hold(Undirected);
    else
      error("Wrong argument! Try Directed or Undirected.");
    end_if;
  end_if;

  if domtype(L) = DOM_LIST then
    _vertices := L;
  else
    _vertices := [i $ i=1..L];
  end_if;
  _edges := [[_vertices[i],_vertices[i+1]] $ i=1..(nops(_vertices)-1)]:
  _edges := append(_edges, [_vertices[nops(_vertices)], _vertices[1]]);

  Graph::new(_vertices, _edges, _directed);
end_proc:

// End of file
null():
