/*-
 createCompleteGraph - generates a complete undirected Graph with n vertices (Clique)
 createCompleteGraph(n)
 Paramters:
   n - non-negative integer that defines the number of vertices to be used
-*/
Graph::createCompleteGraph := proc(n : Type::PosInt)
local i, j, _vertices, _edges, G, _edgesEntering, _edgesLeaving;
begin
  _vertices := [$1..n];
  _edges := [(([i,j] $ j=1..i-1), ([i,j] $ j=i+1..n)) $ i=1..n];
  
  G := Graph([], []);

  // Generate the adjacency lists (without edges like (i, i))
  for i from 1 to nops(_vertices) do
    _edgesEntering[i] := [j $ j=1..(i-1), j $ j=(i+1)..nops(_vertices)];
  end_for;

  _edgesLeaving := _edgesEntering;

  subsop(G, 1=_vertices, 2=_edges, 7=_edgesEntering, 8=_edgesLeaving);
end_proc:

// End of file
null():
