/*
  createRandomEdgeCosts - creates random edge costs
  Parameters:
  G        - Graph
  range    - a range in between which the numbers have to be
  Real|Int - Either the numbers are integer or real.
*/
Graph::createRandomEdgeCosts := proc(G : Graph, range : "_range")
local _edges, edge, _edgeCosts, createNumber, i, domType;
begin
  createNumber := random(range);
  _edges := Graph::getEdges(G);
  domType := Dom::Integer;

  if args(0) = 3 then
    case args(3)
      of Dom::Real do
        domType := Dom::Real;
        break;
      of Dom::Integer do
        break;
      otherwise
        error("Wrong argument definition (try: Dom::Integer or Dom::Real)!");
    end_case;  
  end_if;

  if domType = Dom::Integer then
    for edge in _edges do
      i := createNumber();
      _edgeCosts[edge] := i;
    end_for;
  else
    for edge in _edges do
      i := createNumber();
      i := i + frandom();   
      _edgeCosts[edge] := i;
    end_for;
  end_if;

  subsop(G, 6=_edgeCosts);
end_proc:

// End of file
null():

