/* 
 createRandomGraph - generates a random graph with number of edges and number of vertices
 createRandomGraph(VertexNr, EdgeNr <, Undirected>)
 Parameters:
   VertexNr - positive integer that defines the number of vertices to be used
   EdgeNr   - positive integer that defines the number of edges to be used
   Undirected - if specified, the graph will be undirected
*/
Graph::createRandomGraph := proc(VertexNr : Type::PosInt, EdgeNr : Type::PosInt)
local _vertices, _edges, i, j, _isDirected, createNumber, G2;
begin
  if (args(0) < 1) or (args(0) > 3) then
    error("Wrong number of arguments!");
  end_if;

  _isDirected := TRUE;

  if args(0) = 3 then
    if args(3) = hold(Undirected) then
      _isDirected := FALSE;
    end_if;
  end_if;

  if (fact(VertexNr)/2) < EdgeNr then
  	 warning("Can not produce that many edges! Creating a complete graph instead.");
    return (Graph::createCompleteGraph(VertexNr));
  end_if;

  _edges := [];
  _vertices := [$1..VertexNr];
  // Two while loops with same break condition because edges can be defined multiple !
  createNumber := random(1..VertexNr);
  while nops(_edges) < EdgeNr do
    while nops(_edges) < EdgeNr do
      i := createNumber() $ 1;
      j := createNumber() $ 1;
      while i = j do
        j := createNumber() $ 1;      
      end_while;
      _edges := append(_edges, [i,j])
    end_while;
    if not _isDirected then
      for i from 1 to nops(_edges) do
        _edges[i] := sort(_edges[i]);
      end_for;
    end_if;
    // Remove duplicates:
    _edges:= [op({op(_edges)})];
  end_while;

  if _isDirected then
    G2 := Graph::new(_vertices, _edges, hold(Directed));
  else
    G2 := Graph::new(_vertices, _edges);
  end_if;

  G2;
end_proc:

// End of file
null():
