/*
 depthFirstSearch(G <, StartVertex = v> <, VertexList = [v1,...,vn]>)
 Parameters:
 G           - Graph
 StartVertex - a vertex from which to start
 VertexList  - if the List is given, the order of this list is used (for SCC).
*/
Graph::depthFirstSearch := proc(G : Graph)
local timestamp, _color, _vertices, v, i, _startVertex, _startTime, 
      _finishTime, _parent, dfsVisit;
begin

  dfsVisit :=  proc(_vertex)
  local _adjacentEdges, v2;
  begin
    timestamp := timestamp + 1;
    _color[_vertex] := 1; // gray
    _startTime[_vertex] := timestamp;

    _adjacentEdges := [op(Graph::getAdjacentEdgesLeaving(G, [_vertex]))];
    if (nops(_adjacentEdges) > 0) and (_parent[_vertex] = infinity) then
      _parent[_vertex] := _vertex;
    end_if;
    for v2 in _adjacentEdges do
      if _color[v2] = 0 then
        _parent[v2] := _vertex;
        dfsVisit(v2);
      end_if;       
    end_for;
    _color[_vertex] := 2;
    timestamp := timestamp + 1;
    _finishTime[_vertex] := timestamp;
  end_proc;

  _vertices := Graph::getVertices(G);
  _startVertex := FAIL;
  // For empty graphs:
  _parent := table();
  // here it goes on....

  if args(0) > 1 then    
    for i from 2 to args(0) do
      case op(args(i),1)
        of hold(StartVertex) do
          _startVertex := op(op(args(i),2));
          break;
        of hold(VertexList) do // This option is currently undocumented [2009-10-16]
          _vertices := op(args(i),2);
          break;
        otherwise
          error("Wrong argument definition!");
      end_case;
    end_for;
  end_if;
  
  if _startVertex = FAIL then
    if nops(_vertices) > 0 then
      _startVertex := op(_vertices,1);    	
    else
      return ([table(), table(), table()])
    end_if;
  end_if;

  timestamp := 0;
  // Initialize with visiting-time 0
  for v in _vertices do
    _parent[v] := infinity;
    _color[v] := 0;
  end_for;

  dfsVisit(op(_startVertex));
  // If the graph was not connected there are still vertices not visited !
  for v in _vertices do
    if _color[v] = 0 then
      dfsVisit(op(v));
    end_if;
  end_for;

  for v in _startTime do
    userinfo(NoNL, 1, "Vertex " . expr2text(lhs(v)) . " is found at timestamp " . expr2text(rhs(v)) . "\n" );    
  end_for;

  [_startTime, _finishTime, _parent];
end_proc:

// End of file
null():
