/* getSubGraph - extract a subgraph from a Graph
   getSubGraph(G, v)
   getSubGraph(G, [v1,..vn])
   Parameters:
   G - Graph
   v - vertices of G
*/
Graph::getSubGraph := proc(G : Graph, Vertices : DOM_LIST)
  local _vertices, _edges, G2, i;
begin
  _vertices := select(Graph::getVertices(G), v -> contains(Vertices, v) <> 0);
  _edges := select(Graph::getEdges(G), _edge -> contains(Vertices, _edge[1]) <> 0 and contains(Vertices, _edge[2]) <> 0);

  if Graph::isDirected(G) then
    G2 := Graph::new(_vertices, _edges, hold(Directed));
  else  
    for i from 1 to nops(_edges) do
      _edges[i] := sort(_edges[i]);
    end_for;
    _edges:= [op({op(_edges)})];
    G2 := Graph::new(_vertices, _edges);
  end_if;

  if not Graph::getVertexWeights(G) = FAIL then
    G2 := Graph::setVertexWeights(G2, _vertices, select(Graph::getVertexWeights(G), vw -> contains(_vertices, lhs(vw)) <> 0));
  end_if;

  if not Graph::getEdgeWeights(G) = FAIL then
    G2 := Graph::setEdgeWeights(G2, _edges, select(Graph::getEdgeWeights(G), ew -> contains(_edges, lhs(ew)) <> 0));
  end_if;

  if not Graph::getEdgeCosts(G) = FAIL then
    G2 := Graph::setEdgeCosts(G2, _edges, select(Graph::getEdgeCosts(G),  ec -> contains(_edges, lhs(ec)) <> 0));
  end_if;

  if not Graph::getEdgeDescriptions(G) = FAIL then
    G2 := Graph::setEdgeDescriptions(G2, _edges, select(Graph::getEdgeDescriptions(G),  ec -> contains(_edges, lhs(ec)) <> 0));
  end_if;

  G2;
end_proc:

// End of file
null():
