/*
  isConnected(G, startVertex)
  finds out if a graph is connected or not. 

  Parameters:
  G           - Graph
  
*/
Graph::isConnected := proc(G : Graph)
local parents, counter, singleVertex, i;
begin
  parents := Graph::depthFirstSearch(G);
  parents := op(parents,3);
  // If in the third list the parent is infinity, or more than once vertex=vertex then there exist a single vertex 
  counter := 0;
  singleVertex := 0;
  for i in parents do
    if op(i,1) = op(i,2) then
      counter := counter + 1;
    elif op(i,2) = infinity then
      singleVertex := singleVertex + 1;
    end_if;
  end_for;
  userinfo(NoNL, 1, "Components in the graph: " . expr2text(counter) . "\n" );    
  userinfo(NoNL, 1, "Single vertices in the graph:  " . expr2text(singleVertex) . "\n" );    
  if (singleVertex = 0) and (counter < 2) then
    TRUE;
  else
    FALSE;
  end_if;
end_proc:

// End of file
null():
