//    

/*-
 spath_arg_check - evaluates the arguments of an call of ShortPath or LongPath
-*/
Graph::spath_arg_check := proc(G,v)
local ww,V,a;
begin

   V := Graph::getVertices(G);
   v := op(v);
   a := 0; ww := 0;
   case args(0) 
     of 2 do
        if contains(V,v) = 0 then
           error("Graph doesn't contain specified node!"):
        end_if;
        break;
     of 3 do
        if contains(V,v) = 0 then
           error("Graph doesn't contain specified node!"):
        end_if;
        if contains(V,args(3)) = 0 then
	       if args(3) = hold(Length) then
		      a := a + 1;
 	       elif args(3) = hold(Path) then
		      a := a + 10;
	       else 
	          error("Graph doesn't contain specified node!"):
	       end_if;
        else
	       ww := 1; 
	    end_if; 
        break;
     of 4 do
    	if contains(V,v) = 0 then
           error("Graph doesn't contain specified node!"):
        end_if;
        if contains(V,args(3)) = 0 then
	   if {args(3),args(4)} = {hold(Length),hold(Path)} then
	     a := a + 11;
           else 
             error("Illegal argument!"):
           end_if;
	else
	   ww := 1;
           if args(4) = hold(Length) then
             a := a + 1;
           elif args(4) = hold(Path) then
             a := a + 10;
           else
             error("Illegal argument!"):
           end_if;
	end_if;
	break;
     of 5 do
    	if contains(V,v) = 0 or contains(V,args(3)) = 0 then
           error("Graph doesn't contain specified node!"):
        end_if;
	ww := 1;
	if {args(4),args(5)} = {hold(Length),hold(Path)} then
             a := a + 11;
        else 
             error("Illegal argument!"):
        end_if;
	break;
     otherwise
        error("Wrong number of arguments!");
   end_case;
   if ww = 1 then
	return(a,ww,args(3));
   else
	return(a,ww,-1);
   end_if;
end_proc:

/*-
 spath - generates pathes for ShortPath, ShortPathTo and LongPath
 Parameters:
   V - list of nodes
   v - node
   d - sequence with table of distances and a table with successors or
       predecessors
   a - number, specifying the result: Length (0,1), Path (10), 
       Length & Path (11)
   ww - 1 if one distance (v,..,w) is desired, 0 if all distances are desired
   www - the target node (if ww = 1)
   app - 0 if the pathes are to one single node are desired, 1 if the pathes
         from one single node are desired
-*/
Graph::spath_eval := proc(V,v,dd,a,ww,www,app=1)
local d,dist,sp,path,i,w,u,f,res;
// global v (2nd arg. of ShortPath, ShortPathTo or LongPath) 
// removed 
begin
   res := [];
   dist := op(dd,1);
   d := op(dd,2);

   if ww = 1 then  //- final node specified -
      case a
          of 0 do
            res := [dist[www]];
            break;
         of 1 do
            res := [dist[www]];
            break
         of 11 do
            res := [dist[www]];
         of 10 do
            if dist[www] = infinity then
   		res := append(res, []);
	    else
               w := www;
               path := [w];
               repeat
                  u := d[w];
                  if app =0 then
                     path := listlib::insertAt(path,u,1);
                  else
                     path := append(path,u);
                  end_if;
                  w := u;
               until (w = v) end_repeat;
               res := append(res,path);
            end_if;
      end_case;
   else //- no final node specified -
      case a
          of 0 do
            res := [dist];
            break;
         of 1 do
            res := [dist];
            break
         of 11 do
            res := [dist];
         of 10 do
     	    sp := table();
	        f := proc() begin bool((args(1) <> v) and (dist[args(1)] <> infinity)) end_proc ;
            for i in select(V, f) do
               path := [i];
               w := i;
               repeat 
	          u := d[w];
	          if app =0 then
                 path := listlib::insertAt(path,u,1);
              else
                 path := append(path,u);
              end_if;
	          w := u;
               until (w = v) or (contains(sp,w)) end_repeat;
               if contains(sp,w) then
		  if app = 0 then
		     delete path[1];
		     sp[i] := sp[w].path;
		  else
		     delete path[nops(path)];
		     sp[i] := path.sp[w] ;
		  end_if;
               else
	          sp[i] := path;
               end_if;
            end_for;
            res := append(res,sp);
      end_case;
   end_if;
   op(res);
end_proc:

 /*-
 lbellman - longest path algorithm of Bellman
 "On a routing problem", Quart. Appl. Math. 16 (1958)
 Running time O(|V| |Edge|) (FIFO implementation)
 Taken from: Ahuja, Magnanti, Orlin: Graph Flows, Prentice-Hall, 1993
             Section 5.4
-*/
Graph::lbellman := proc(V, Epo, Ew, v)
local d,j,LIST,i,C,prec,pass;
begin
C := (nops(V)+1) * max(op(Ew, [1..nops(Ew),2]));
d := table((V[i] = -infinity $ i=1..nops(V)));
d[v] := 0;
LIST := [v];
pass := table((V[i] = 0 $ i=1..nops(V)));
while LIST <> [] do
    i := LIST[1];
    delete LIST[1];
    pass[i] := pass[i] + 1;
    if pass[i] > nops(V) then
     	error("Graph contains negative cycle!");
    end_if;
    for j in Epo[i] do
        if d[j] < d[i] + Ew[[i,j]] then
            d[j] := d[i] + Ew[[i,j]];
            prec[j] := i;
            if contains(LIST, j) = 0 then
                LIST := append(LIST, j);
            end_if;
        end_if;
    end_for;
end_while;
[d,prec];
end_proc:

/*-
 longestPath - longest pathes for one node
 longestPath(G,v)
 longestPath(G,v,w)
 longestPath(G,v,<Path>, <Length>)
 longestPath(G,v,w,<Path>, <Length>)
 Parameters:
   G - Graph
   v,w - node of the Graph G
   Path, Length - keywords

 longPath(G,v) returns a table with the length of longest pathes from 
 v to all other nodes in the Graph. longPath(G,v,w) gives the length 
 of a longest path from v to w. Uses Graph::lbellman. If the optional 
 argument Path is given, then a table with longest pathes are returned. 
 If Length and Path are given, then both the length of the longest pathes 
 and the pathes are returned.
-*/
Graph::longestPath := proc(G,v)
local T,d,www,ww,V,Ew,Epo,a;
begin
   
  if args(0) < 2 or args(0) > 5 then
    error("Wrong number of arguments!");
  end_if;
  Graph::graphCheck(G);
  if not Graph::isDirected(G) then
    error("Graph must be directed for longest path.");
  end_if;
    
   T := Graph::spath_arg_check(args());
   a := T[1];
   ww := T[2];
   www := T[3];

   V := Graph::getVertices(G);
   Epo := Graph::getEdgesLeaving(G);
   Ew := Graph::getEdgeWeights(G);

   d := Graph::lbellman(V, Epo, Ew, op(v));
   Graph::spath_eval(V, v, d, a, ww, www);
end_proc:
