/*- 
 maxFlow - computes a maximal flow
 maxFlow(G, t, t)
 Parameters:
   G    - Graph
   s, t - vertices in G
 Computes a maximal flow from t to t in G.
 Uses Graph::pp_fifo.
-*/
Graph::maxFlow := proc(G : Graph, s : DOM_LIST, t : DOM_LIST)
begin
  if args(0) <> 3 then
    error("Wrong number of arguments!");
  end_if;
  if not Graph::isVertex(G,s) or not Graph::isVertex(G,t) then
    error("Specified vertices are not contained in graph!");
  end_if;

  Graph::pp_fifo(G, s, t);
end_proc:

// End of file
null():
