/*- 
 minCut - computes a minimal cut
 minCut(G,s,t)
 Parameters:
   G - Graph
   s,t - vertices in G
 Computes a minimal cut seperating s and t in G.
 Uses Graph::pp_fifo.
-*/

Graph::minCut := proc(G : Graph,s : DOM_LIST,t : DOM_LIST)
local _vertices, _edges, _edgeWeights, _edgesLeaving, _edgesEntering,flow,cutset,S,Q,i,j,e,vc;
begin
  if args(0) <> 3 then
    error("Wrong number of arguments!");
  end_if;
  if not Graph::isVertex(G,s) or not Graph::isVertex(G,t) then
    error("Specified vertices are not contained in graph!");
  end_if;

  _vertices := Graph::getVertices(G);
  _edges := Graph::getEdges(G);
  _edgeWeights := Graph::getEdgeWeights(G);
  _edgesLeaving := Graph::getEdgesLeaving(G);
  _edgesEntering := Graph::getEdgesEntering(G);

  if _edgeWeights = FAIL then
    for i in _edges do
      _edgeWeights[i] := 1;
    end_for;
  elif nops(_edgeWeights) < nops(_edges) then
    for i in _edges do
      if not contains(_edgeWeights, i) then
        _edgeWeights[i] := 1;        	
      end_if;
    end_for;    	
  end_if;

  flow := Graph::pp_fifo(G, s,t);
  vc := op(flow,1);
  flow := op(flow,2);
  s := op(s);
  t := op(t);

  /*- 
   Compute a minimal cut [S,T] with s in S and t in T.
   S is the set of all nodes, for which there exists a path
   from s in the reduced Graph.
  -*/
  S := {s}:
  Q := [s]:
  while Q <> [] do
     i := Q[1]:
     delete Q[1];
     for j in _edgesLeaving[i] do
        e := [i,j];
        if _edgeWeights[e] - flow[e] > 0 then
           if contains(Q,j) = 0 then
              Q := append(Q,j);
              S := S union {j};
           end_if;
        end_if;
     end_for;
   end_while:
   cutset := [];
   for i in S do 
      for j in _edgesLeaving[i] do
         if contains(S,j) then
      next;
   else
      cutset := append(cutset,[i,j]);
   end_if;
      end_for;
   end_for;
   vc, cutset;
end_proc:

// End of file
null():
