/*
 minimumSpanningTree - returns a new Graph that only consist of the minimum spanning edges.
 minimumSpanningTree(G <,SearchFor = Weights|Costs> < , ReturnAsTable>) 
 Paramters:
 G             - Graph
 Weights|Costs - defines wether to use the weight or the costs of the edges. Default = Weights
 ReturnAsTable - defines wether the output will be a new Graph or a tabular form. Default = Graph
*/
Graph::minimumSpanningTree := proc(G : Graph)
local _arguments, searchFor, output, leftOperator, rightOperator, i, j; //searchWith

begin

 // Check for connectivity
 if not Graph::isConnected(G) then
 	 error("Graph is not connected. Can not create a minimum spanning tree.");
 end_if;

 //  searchWith := hold(Kruskal);
  searchFor := hold(Weights);
  output := hold(Graph);  

  _arguments := args();
  j := args(0);

  for i from 2 to j do
    if _arguments[i] = hold(ReturnAsTable) then
      output := hold(Table);
      delete _arguments[i];
      j := j - 1;
      break;
    end_if;
  end_for;

  for i from 2 to j do
    leftOperator := op(_arguments[i],1);
    rightOperator := op(_arguments[i],2);
    case leftOperator
//      of hold(SearchWith)
//        if rightOperator = hold(Prim) then
//          searchFor := hold(Prim);  
//        elif rightOperator = hold(Kruskal) then
//        else
//          error("Wrong argument type for " . leftOperator . ": Kruskal or Prim expected!");
//       end_if;
//      of hold(StartVertex) do
//        break;
      of hold(SearchFor) do
        if rightOperator = hold(Costs) then
          searchFor := hold(Costs);  
        elif rightOperator = hold(Weights) then
        else
          error("Wrong argument type for " . leftOperator . ": Weights or Costs expected!");
        end_if;
        break;
      otherwise
        error("Wrong argument!");
    end_case;
  end_for;

  // If empty, return empty graph
  if Graph::isEmpty(G) then
    if output=hold(Table) then
      return (table());
    else
      return (G);
    end_if;
  end_if;

  if output = hold(Graph) then
    Graph::mst_Kruskal(G, searchFor);
  else
    Graph::mst_Kruskal(G, searchFor, hold(ReturnAsTable));  	
  end_if;
end_proc:

/*
 mst_Kruskal - returns a new Graph or table that only consist of the minimum spanning edges.
 minimumSpanningTree(G <,Weights|Costs> <,Graph|Tables>)
 Paramters:
 G             - Graph
 Weights|Costs - defines wether to use the weight or the costs of the edges. Default = Weights
 Graph|Tables  - defines wehter the output will be a new Graph or a tabular form. Default = Graph
*/
Graph::mst_Kruskal := proc(G : Graph)
local _vertices, _edgeNumbers, C, u, v, parentTable, rankTable, i, _edges, _kruskal, sumOfMSP, output,
      makeSet, unionSet, linkSet, findSet,  // For the set.
      _edgeWeights, _edgeCosts, _edgeDescriptions, _edgesEntering, _edgesLeaving, dummyTable, _isDirected;
     

begin
  _edgeNumbers := Graph::getEdgeWeights(G);
  output := hold(Graph);

  if args(0) > 1 then
    for i from 2 to args(0) do
      case args(i)
        of hold(Costs) do
          _edgeNumbers := Graph::getEdgeCosts(G);
          break;
        of hold(Weights) do
          break;
        of hold(Graph) do
          break;
        of hold(ReturnAsTable) do
          output := hold(Tables);
          break;
        otherwise
          error("Wrong argument definition.");
      end_case;     
    end_for;
  end_if;

  _edges := Graph::getEdges(G);

  // If the graph is unweighted
  if _edgeNumbers = FAIL then
    for i in _edges do
      _edgeNumbers[i] := 1;
    end_for;
  end_if;

  // There are no edges
  if nops(_edges) = 0 then
    error("No edges exist to create a minimum spanning tree.");
  end_if;

  // local method makeSet
  // v - vertex
  // creates the connection to the parent vertex and sets its rank to 0.
  makeSet:= proc(v)
  begin
    parentTable[v] := v;
    rankTable[v] := 0;
  end_proc;

  // local method unionSet
  // u,v - vertex
  // creates the connection to the parent vertex and sets its rank to 0.
  unionSet := proc(u, v)
  begin
    linkSet(findSet(u), findSet(v));
  end_proc;

  // local method linkSet
  // u,v - vertex
  // sets the rank of the better vertex higher.
  linkSet := proc(u, v)
  begin
    if rankTable[u] > rankTable[v] then
      parentTable[v] := u;
    else
      parentTable[u] := findSet(parentTable[v]);
      if rankTable[u] = rankTable[v] then
        rankTable[v] := rankTable[v] + 1;
      end_if;
    end_if;
  end_proc;

  // local method findSet
  // v - vertex
  // finds a given vertex if it exist.
  findSet := proc(v)
  begin
    if (not v = parentTable[v]) then
      parentTable[v] := findSet(parentTable[v]);
    end_if;
    parentTable[v];
  end_proc;

  _isDirected := Graph::isDirected(G);
  _vertices := Graph::getVertices(G);
  parentTable := table();
  rankTable := table();
  
  // Now a sorting of edges with the predefined order is created.
  C := (nops(_edgeNumbers)+1) * max(op(_edgeNumbers, [1..nops(_edgeNumbers),2]));
  // If edges have no weight, weight 1 is assumed for every edge.
  if C = FAIL then
    C := (nops(_edgeNumbers)+1);
  end_if;
  sumOfMSP := 0;

  for u in _vertices do
    makeSet(u);
  end_for; 

  /* Since only the edge values are interesting, reverted edges have to be removed... */
  //if (not _isDirected) then
  //  for i from 1 to nops(_edges) do
  //    _edges[i] := sort(_edges[i]);
  //  end_for;
  //  _edges := sort(_edges, (x, y) -> (if op(x,1) = op(y,1) then	sysorder(op(x,2), op(y,2)); else sysorder(op(x,1), op(y,1)); end_if;));
    //_edges := sort(_edges);
  //  _edges := listlib::removeDuplicates(_edges, KeepOrder);   
  //end_if;

  _edges := Graph::createMinSort(_edgeNumbers);

  for i from 1 to nops(_edges) do
    u := op(_edges[i],1);
    v := op(_edges[i],2);
    if not (findSet(u) = findSet(v)) then      
      unionSet(u, v);
      if not Graph::isDirected(G) and output = hold(Tables) then
        _kruskal[[v, u]] := _edgeNumbers[[v, u]];	
      end_if;
      _kruskal[[u, v]] := _edgeNumbers[[u,v]];
      sumOfMSP := sumOfMSP + _edgeNumbers[[u,v]];
    end_if;
  end_for;
  
  if output = hold(Tables) then
    [_kruskal, sumOfMSP];
  else
    _edges := [];
    dummyTable := op(_kruskal);
    for i in dummyTable do
      _edges := append(_edges,op(i,1));     
    end_for;
    // _edges consist only of |V|-1 edges !!!
    _edges := sort(_edges, (x, y) -> (if op(x,1) = op(y,1) then	sysorder(op(x,2), op(y,2)); else sysorder(op(x,1), op(y,1)); end_if;));

    dummyTable := Graph::getEdgeCosts(G);
    if (not dummyTable = FAIL)  then
      for i in _edges do
        _edgeCosts[i] := dummyTable[i];
        if not _isDirected then
          _edgeCosts[revert(i)] := dummyTable[i];        	
        end_if;
      end_for;
    else
      _edgeCosts := FAIL;
    end_if;

    dummyTable := Graph::getEdgeWeights(G);
    if (not dummyTable = FAIL)  then
      for i in _edges do
        _edgeWeights[i] := dummyTable[i];
        if not _isDirected then
          _edgeWeights[revert(i)] := dummyTable[i];        	
        end_if;
      end_for;
    else
      _edgeWeights := FAIL;
    end_if;

    dummyTable := Graph::getEdgeDescriptions(G);
    if (not dummyTable = FAIL)  then
      for i in _edges do
        _edgeDescriptions[i] := dummyTable[i];
        if not _isDirected then
          _edgeDescriptions[revert(i)] := dummyTable[i];        	
        end_if;
      end_for;
    else
      _edgeDescriptions := FAIL;
    end_if;

    if not _isDirected then
      _edges := _edges . map(_edges, revert);    	
    end_if;

    _edgesEntering := table((_vertices[i]=sort( map(select(_edges, _edge->op(_edge,2)=_vertices[i]), op, 1) ) $ i=1..nops(_vertices))):
    // Speedup:
    if _isDirected then
      _edgesLeaving  := table((_vertices[i]=sort( map(select(_edges, _edge->op(_edge,1)=_vertices[i]), op, 2) ) $ i=1..nops(_vertices))):
    else
      _edgesLeaving := _edgesEntering;
    end_if;

    subsop(G, 2=_edges, 4=_edgeDescriptions, 5=_edgeWeights, 6=_edgeCosts, 7=_edgesEntering, 8=_edgesLeaving);
  end_if;

end_proc:

// End of file
null():
