/*-
  pp_fifo - computes maximal flow
  FIFO-Preflow-Push-Algorithm of Goldberg&Tarjan.
  "A new approach to the maximum-flow problem", Journal ACM 35(4), 1988
  Running time: O(n^3)
  Uses an exact distance labelling.
-*/
Graph::pp_fifo := proc(G : Graph, s : DOM_LIST, t : DOM_LIST)
local Vd,d,inflow,outflow,preflow,i,summe,Q,relabel,dist_sink,schritt,
      _vertices, _edges, _edgeWeights, _edgesEntering, _edgesLeaving;
begin

  _vertices := Graph::getVertices(G);
  _edges := Graph::getEdges(G);
  _edgeWeights := Graph::getEdgeWeights(G);
  _edgesEntering := Graph::getEdgesEntering(G);
  _edgesLeaving := Graph::getEdgesLeaving(G);

  // If no "Capacities" are predefined, 1 will be used.
  if _edgeWeights = FAIL then
    for i in _edges do
      _edgeWeights[i] := 1;
    end_for;
  elif nops(_edgeWeights) < nops(_edges) then
    for i in _edges do
      if not contains(_edgeWeights, i) then
        _edgeWeights[i] := 1;        	
      end_if;
    end_for;    	
  end_if;

  s := op(s);
  t := op(t);

    /*
      relabel
    */
    relabel := proc(v, flow, d, _edgeWeights, _edgesLeaving, _edgesEntering)
    local i,e,mini;
    begin
      mini := 3 * nops(_edgesLeaving); //- Upper bound for distance labels: 3 * |_vertices| -
      for i in _edgesLeaving[v] do 
        e := [v,i];
        if _edgeWeights[e]-flow[e] > 0 and d[v] <= d[i] then
          mini := min(mini, d[i]+1);
        end_if;
      end_for;
      for i in _edgesEntering[v] do 
        e := [i,v];
        if flow[e] > 0 and d[v] <= d[i] then
          mini := min(mini, d[i]+1);
        end_if;
      end_for;
      d[v] := mini;
      d;
    end_proc:

    /*--
     dist_sink - Berechnet den Abstand der Knoten zur Senke
     Es werden die k"urzesten Wege von der Senke t zu allen "ubrigen Knoten
     im Netzwerk berechnet. Das Ergebnis ist eine Tabelle d, mit
            d[v] = L"ange des k"urzesten Weges von v nach t
    --*/
    dist_sink := proc(_vertices,_edgesEntering,t)
    local d,j,LIST,i,n;
    begin
      n := nops(_vertices);
      d := table(_vertices[i] = n $ i=1..nops(_vertices));
      d[t] := 0;
      LIST := [t];
      while LIST <> [] do
        i := LIST[1];
        delete LIST[1];
        for j in _edgesEntering[i] do
          if d[j] > d[i] + 1 then
            d[j] := d[i] + 1;
            if contains(LIST, j) = 0 then
              LIST := append(LIST, j);
            end_if;
          end_if;
        end_for;
      end_while;
      d;
    end_proc:

    schritt := proc(QQ)
    local Q,i,j,e,f,PP,v,abgabe;
    begin
      Q:=QQ; // to avoid warnings 
      for i in Q do
        PP := inflow[i] - outflow[i];
        j := 1;
        v := op(_edgesLeaving[i],j);
        /*--  Abgabe an Nachfolgeknoten --*/
        while v <> FAIL and 0 < PP do
          e := [i,v];
          if d[i] = d[v]+1 then
            abgabe := max(min(_edgeWeights[e] - preflow[e], PP), 0);
            preflow[e] := preflow[e] + abgabe;
            PP := PP-abgabe; 
            outflow[i] := outflow[i] + abgabe;
            inflow[v] := inflow[v] + abgabe;
          end_if;
          j := j+1;
          v := op(_edgesLeaving[i],j);
        end_while;
        j := 1;
        v := op(_edgesEntering[i],j);
        /*-- Rueckgabe an Vorg"angerknoten --*/
        while v <> FAIL and 0 < PP do 
          e := [v,i];
          if d[i] = d[v]+1 then
            abgabe := max(min(preflow[e], PP),0);
            preflow[e] := preflow[e] - abgabe;
            PP := PP - abgabe;
            inflow[i] := inflow[i] - abgabe;
            outflow[v] := outflow[v] - abgabe;
          end_if;
          j := j+1;
          v := op(_edgesEntering[i],j);
        end_while;
        /*- Es konnte nicht der ganze "Uberschu"t verteilt werden -> Relabel -*/
        if PP > 0 then 
          d := relabel(i, preflow, d, _edgeWeights, _edgesLeaving, _edgesEntering); 
        end_if;
      end_for;

      f := proc() begin bool(inflow[args(1)] <> outflow[args(1)]) end_proc ;
      Q := select(Vd, f);
    end_proc:

  Vd := [op({op(_vertices)} minus {s,t})];
  d := dist_sink(_vertices, _edgesEntering,t);
  d[s] := nops(_vertices);
  d[FAIL] := 0;
  preflow := table(_edges[i] = 0 $ i=1..nops(_edges));
  inflow := table(_vertices[i] = 0 $ i=1..nops(_vertices));
  outflow := inflow;
   
  Q := []:
  for i in _edgesLeaving[s] do
    preflow[[s,i]] := _edgeWeights[[s,i]];
    outflow[s] := outflow[s] + _edgeWeights[[s,i]];
    inflow[i] := _edgeWeights[[s,i]];
    Q := append(Q, i);
  end_for;

  Q := schritt(Q);
  while Q <> [] do
    Q := schritt(Q);
  end_while;

  delete i;
  summe := _plus(preflow[[_edgesEntering[t][i],t]] $ i=1..nops(_edgesEntering[t]));

  summe, preflow;
end_proc:

// End of file
null():
