/*- 
 removeVertex - removes one or several vertices from a Graph. CAUTION: If a vertex is removed that is used within
                any edge, the edge will be deleted, too.
 removeVertex(G, Vertex)
 removeVertex(G, [v1,..,vn])
 Parameters:
   G              - Graph
   Vertex         - a list of one or more vertices

-*/
Graph::removeVertex := proc(G : Graph, Vertex:DOM_LIST)
local _vertices, _vertexWeights, _correctVertices, v, _edge, position, _edges, _edgesLeaving, _edgesEntering;
begin
    if args(0) > 2 then
      error("Wrong number of arguments! See help for more details.")
    end_if;

  // Get the already existing vertices
  _correctVertices := Graph::selectVertex(G, Vertex, TRUE, Show=FALSE);
  _vertices := Graph::getVertices(G);
  _vertexWeights := Graph::getVertexWeights(G);
  _edgesEntering := Graph::getEdgesEntering(G);
  _edgesLeaving  := Graph::getEdgesLeaving(G);

  // Check was already done and only existing vertices remain !
  for v in _correctVertices do

    // Every time !
    _edges := Graph::getEdges(G);
    for _edge in _edges do
      if contains(_edge, v) > 0 then
        G := Graph::removeEdge(G, [_edge]);
      end_if;
    end_for;

    position := contains(_vertices, v);
    if position > 0 then
      delete _vertices[position];
    end_if;

    if _vertexWeights <> FAIL then
      delete _vertexWeights[v];           
    end_if;

    _edgesEntering := Graph::getEdgesEntering(G);
    delete _edgesEntering[op(v)];

    _edgesLeaving := Graph::getEdgesLeaving(G);
    delete _edgesLeaving[op(v)];

  end_for;           

  subsop(G, 1=_vertices, 3=_vertexWeights, 7=_edgesEntering, 8=_edgesLeaving);
end_proc:

// End of file
null():

