/*-
 residualGraph - computes the residual Graph
 residualGraph(G, flow <, Extended>)
 Parameters:
    G - Graph
    flow - flow in G (a table with flow[_edge] = c, when c units flow over the edge _edge)
    Extended - if Extended is stated, also those edges with a zero
               residual capacity are contained. Otherwise those edges are omitted.
-*/
Graph::residualGraph := proc(G : Graph, flow)
local _edges,_edge,_edgeCosts,de,der,dec,dew,ce,cec,cew,G1,_edgeWeights,reverse;
begin
  if args(0) < 2 or args(0) > 3 then
    error("Wrong number of arguments!");
  end_if;
  if not Graph::admissibleFlow(G, flow) then
    error("Specified flow is inadmissible in the given Graph!");
  end_if;   
  if args(0) = 3 then 
    if args(3) <> hold(Extended) then
      error("Illegal argument!");
    end_if;
  end_if; 
        
  reverse := proc() begin [args(1)[2],args(1)[1]] end_proc ;
  
  _edges := Graph::getEdges(G);
  _edgeCosts := Graph::getEdgeCosts(G);
  _edgeWeights := Graph::getEdgeWeights(G);

  // If no "Capacities" are predefined, 1 will be used.
  if _edgeWeights = FAIL then
    for _edge in _edges do
      _edgeWeights[_edge] := 1;
    end_for;
    G := Graph::setEdgeWeights(G, _edges, _edgeWeights, OnlySpecifiedEdges);
  elif nops(_edgeWeights) < nops(_edges) then
    for _edge in _edges do
      if not contains(_edgeWeights, _edge) then
        _edgeWeights[_edge] := 1;      	
      end_if;
    end_for;
    G := Graph::setEdgeWeights(G, _edges, _edgeWeights, OnlySpecifiedEdges);
  end_if;

  if _edgeCosts = FAIL then
    for _edge in _edges do
      _edgeCosts[_edge] := 1;
    end_for;
    G := Graph::setEdgeCosts(G, _edges, _edgeCosts, OnlySpecifiedEdges);
  elif nops(_edgeCosts) < nops(_edges) then
    for _edge in _edges do
      if not contains(_edgeCosts, _edge) then
        _edgeCosts[_edge] := 1;      	
      end_if;
    end_for;
    G := Graph::setEdgeCosts(G, _edges, _edgeCosts, OnlySpecifiedEdges);
  end_if;

  if args(0) = 3 then   // Extended Graph: don't omit empty edges 
    der := []; dec := []; dew := [];
    ce := []; cec := []; cew := [];
    for _edge in _edges do
      if flow[_edge] > 0 then
        ce := append(ce,_edge);
        cec := append(cec, _edgeWeights[_edge]-flow[_edge]);
        if not Graph::isEdge(G, [reverse(_edge)]) then
          der := append(der, reverse(_edge));
          dec := append(dec, flow[_edge]);
          dew := append(dew, -_edgeWeights[_edge]); 
        end_if;
      end_if;
    end_for;
    G1 := G;
    if nops(der) > 0 then
      G1 := Graph::addEdges(G1, der, hold(EdgeCosts)=dec, hold(EdgeWeights)=dew, OnlySpecifiedEdges);
    end_if;
    if nops(ce) > 0 then
      G1 := Graph::setEdgeCosts(G1, ce, cec, OnlySpecifiedEdges);
    end_if;
  else // omit empty edges 
    de := []; der := []; dec := []; dew := [];
    ce := []; cec := []; cew := [];
    for _edge in _edges do
      if flow[_edge] > 0 then
        if flow[_edge] = _edgeWeights[_edge] then
          de := append(de,_edge);
        else
          ce := append(ce,_edge);
          cec := append(cec, _edgeWeights[_edge]-flow[_edge]);
        end_if;
        if not Graph::isEdge(G, [reverse(_edge)]) then
          der := append(der, reverse(_edge));
          dec := append(dec, flow[_edge]);
          dew := append(dew, -_edgeWeights[_edge]+flow[_edge]); 
        end_if;
      end_if;
    end_for;
    G1 := G;
    if nops(de) > 0 then
       G1 := Graph::removeEdge(G1, de, OnlySpecifiedEdges);
    end_if;
    if nops(der) > 0 then
      G1 := Graph::addEdges(G1, der, hold(EdgeWeights)=dec, hold(EdgeCosts)=dew, OnlySpecifiedEdges);
    end_if;
    if nops(ce) > 0 then
      G1 := Graph::setEdgeWeights(G1, ce, cec, OnlySpecifiedEdges);
    end_if;
  end_if;
  G1;
end_proc:

// End of file
null():
