// 
/* revert: revert all edges of a Graph (makes only sense for a directed graph !)
   revert(G)

   Parameters:
   G - Graph

   ccr, 7.01.03: Changed from revertGraph to revert, to use
   overloading of the system function revert().
*/

Graph::revert := proc(G : Graph)
  local _vertices, _edges, _edgeWeights, _edgeCosts, _edgeDescriptions, G2;
begin

  _vertices := Graph::getVertices(G);
  _edges := map(Graph::getEdges(G), revert);

  if Graph::isDirected(G) then
    G2 := Graph::new(_vertices, _edges, hold(Directed));
  else  
    return(G);  // because there is nothing to revert !
  end_if;
  
  if not Graph::getVertexWeights(G) = FAIL then
    G2 := Graph::setVertexWeights(G2, _vertices, Graph::getVertexWeights(G));
  end_if;

  if not Graph::getEdgeWeights(G) = FAIL then
    _edgeWeights := table(op(map([op(Graph::getEdgeWeights(G))], ew -> revert(lhs(ew))=rhs(ew))));
    G2 := Graph::setEdgeWeights(G2, _edges, _edgeWeights);
  end_if;

  if not Graph::getEdgeCosts(G) = FAIL then
    _edgeCosts := table(op(map([op(Graph::getEdgeCosts(G))], ec -> revert(lhs(ec))=rhs(ec))));
    G2 := Graph::setEdgeCosts(G2, _edges, _edgeCosts);
  end_if;

  if not Graph::getEdgeDescriptions(G) = FAIL then
    _edgeDescriptions := table(op(map([op(Graph::getEdgeDescriptions(G))], ec -> revert(lhs(ec))=rhs(ec))));
    G2 := Graph::setEdgeDescriptions(G2, _edges, _edgeDescriptions);
  end_if;

  G2;
end_proc:

// End of file
null():
