/*-
 setEdgeCosts - changes the costs of one ore more edges of a Graph
 setEdgeCosts(G, Edge, EdgeCosts <,OnlySpecifiedEdges>)
 setEdgeCosts(G, [e1,..,en], [c1,..,cn] <,OnlySpecifiedEdges>)
 Parameters:
   G        - Graph
   Edge     - a list of lists of one or more edges
   EdgeCosts - a list or table of one or more edge costs
-*/
Graph::setEdgeCosts := proc(G : Graph, Edge : Type::ListOf(DOM_LIST), EdgeCosts : Type::Union(DOM_LIST, DOM_TABLE))
local _edges, _existingEdges, _edgeCosts, position, x, _onlySE, reverted;
begin
  _onlySE := FALSE;
  if args(0) = 4 then
     if op(args(4)) = hold(OnlySpecifiedEdges) then
       _onlySE := TRUE;
     end_if;
  end_if;  

  _edges := Graph::getEdges(G);
  _edgeCosts := Graph::getEdgeCosts(G);
  _existingEdges := Graph::selectEdge(G, Edge, TRUE, Show=FALSE, OnlySpecifiedEdges=_onlySE);

  if _existingEdges = [] then
    warning("No edge cost to be changed.");
  else
    if domtype(EdgeCosts) = DOM_TABLE then
      for x in _existingEdges do
        reverted := FALSE;
        if contains(EdgeCosts, x) = FALSE then // check the reverted edge if original edge does not exist!
          x := [op(x,2),op(x,1)];
          reverted := TRUE;
        end_if;
        if EdgeCosts[x] = hold(None) then
          // remove edge from list, because it is not necessary.
          if reverted then
            x := [op(x,2),op(x,1)];
            if _edgeCosts <> FAIL and contains(_edgeCosts, x) then
               delete _edgeCosts[x];
            end_if;
          else  
            if _edgeCosts <> FAIL and contains(_edgeCosts, x) then
               delete _edgeCosts[x];
            end_if;
          end_if;
        else
          if reverted then
            if contains(EdgeCosts, x) then
              _edgeCosts[[op(x,2),op(x,1)]] := EdgeCosts[x];
            end_if;
          else  
            if contains(EdgeCosts, x) then
              _edgeCosts[x] := EdgeCosts[x];
            end_if;
          end_if;
        end_if;
      end_for;
    else
      for x in _existingEdges do
        reverted := FALSE;
        position := contains(Edge, x);

        if position = 0 then
          x := [op(x,2),op(x,1)];
 	        position := contains(Edge, x);
          reverted := TRUE;
        end_if;
        // just overwrite the predefined weight or create a new one if not defined before.
        if EdgeCosts[position] = hold(None) then
          // remove edge out of list, because it is not necessary.
          if reverted then
            if _edgeCosts <> FAIL and contains(_edgeCosts, [op(x,2),op(x,1)]) then
               delete _edgeCosts[[op(x,2),op(x,1)]];
            end_if;
          else  
            if _edgeCosts <> FAIL and contains(_edgeCosts, x) then
               delete _edgeCosts[x];
            end_if;
          end_if;
        else
          if reverted then
            if position > 0  then
              _edgeCosts[[op(x,2),op(x,1)]] := EdgeCosts[position];
            end_if;
          else  
            if position > 0 then
              _edgeCosts[x] := EdgeCosts[position];
            end_if;  
          end_if;
        end_if;
      end_for;
    end_if;
  end_if;

  subsop(G, 6=_edgeCosts);
end_proc:

// End of file
null():

