/*-
 setEdgeDescriptions - changes the Description of one or more edges of a Graph
 setEdgeDescriptions(G, Edge, EdgeDescriptions <,OnlySpecifiedEdges>)
 setEdgeDescriptions(G, [e1,..,en], [d1,..,dn] <,OnlySpecifiedEdges>)
 Parameters:
   G            - Graph
   Edge         - a list of lists of one or more edges
   EdgeWeights - a list of one or more edge descriptions
-*/
Graph::setEdgeDescriptions := proc(G : Graph, Edge : Type::ListOf(DOM_LIST), EdgeDescriptions : Type::Union(DOM_LIST, DOM_TABLE))
local _edges, _existingEdges, _edgeDescriptions, position, x, _onlySE, reverted;
begin
  _onlySE := FALSE;
  if args(0) = 4 then
      if op(args(4)) = hold(OnlySpecifiedEdges) then
       _onlySE := TRUE;
     end_if;
  end_if;  

  _edges := Graph::getEdges(G);
  _edgeDescriptions := Graph::getEdgeDescriptions(G);
  _existingEdges := Graph::selectEdge(G, Edge, TRUE, Show=FALSE, OnlySpecifiedEdges=_onlySE);

  if _existingEdges = [] then
    warning("No edge description to be changed.");
  else
    if domtype(EdgeDescriptions) = DOM_TABLE then
      for x in _existingEdges do
        reverted := FALSE;
        if contains(EdgeDescriptions, x) = FALSE then // check the reverted edge if original edge does not exist!
          x := [op(x,2),op(x,1)];
          reverted := TRUE;
        end_if;
        if EdgeDescriptions[x] = hold(None) then
          // remove edge from list, because it is not necessary.
          if reverted then
            x := [op(x,2),op(x,1)];
            if _edgeDescriptions <> FAIL and contains(_edgeDescriptions, x) then
               delete _edgeDescriptions[x];
            end_if;
          else  
            if _edgeDescriptions <> FAIL and contains(_edgeDescriptions, x) then
               delete _edgeDescriptions[x];
            end_if;
          end_if;
        else
          if reverted then
            if contains(EdgeDescriptions, x) then
               _edgeDescriptions[[op(x,2),op(x,1)]] := EdgeDescriptions[x];
            end_if;
          else
            if contains(EdgeDescriptions, x) then
               _edgeDescriptions[x] := EdgeDescriptions[x];
            end_if;
          end_if;
        end_if;
      end_for;
    else
      for x in _existingEdges do
        reverted := FALSE;
        position := contains(Edge, x);

        if position = 0 then
          x := [op(x,2),op(x,1)];
 	        position := contains(Edge, x);
          reverted := TRUE;
        end_if;

        // just overwrite the predefined weight or create a new one if not defined before.
        if EdgeDescriptions[position] = hold(None) then
          // remove edge out of list, because it is not necessary.
          if reverted then
            if _edgeDescriptions <> FAIL and contains(_edgeDescriptions, [op(x,2),op(x,1)]) then
               delete _edgeDescriptions[[op(x,2),op(x,1)]];
            end_if;
          else  
            if _edgeDescriptions <> FAIL and contains(_edgeDescriptions, x) then
               delete _edgeDescriptions[x];
            end_if;
          end_if;
        else
          if not type(EdgeDescriptions[position]) = DOM_STRING then
            if reverted then
              if position > 0 then
                _edgeDescriptions[[op(x,2),op(x,1)]] := expr2text(EdgeDescriptions[position]);
              end_if;
            else  
              if position > 0 then
                _edgeDescriptions[x] := expr2text(EdgeDescriptions[position]);
              end_if;
            end_if;
          end_if;
          if reverted then
            if position > 0 then
              _edgeDescriptions[[op(x,2),op(x,1)]] := EdgeDescriptions[position];            	
            end_if;
          else  
            if position > 0 then
              _edgeDescriptions[x] := EdgeDescriptions[position];            	
            end_if;
          end_if;
        end_if;
      end_for;
    end_if;
  end_if;

  subsop(G, 4=_edgeDescriptions);
end_proc:

// End of file
null():

