/*-
 setVertexWeights - changes the weight of one ore more edges of a Graph
 setVertexWeights(G, Vertex, VertexWeights)
 setVertexWeights(G, [v1,..,vn], [c1,..,cn])
 Parameters:
   G                - Graph
   Vertex           - a list of one or more vertices
   VertexWeights    - a list of one or more vertice weights
-*/
Graph::setVertexWeights := proc(G : Graph, Vertex : DOM_LIST, VertexWeights : Type::Union(DOM_LIST, DOM_TABLE))
local _vertices, _existingVertices, position, x, _vertexWeights;
begin
    if args(0) > 3 then
      error("Wrong number of arguments! See help for more details.");
    end_if;

  _vertices := Graph::getVertices(G);
  _vertexWeights := Graph::getVertexWeights(G);
  _existingVertices := Graph::selectVertex(G, Vertex, TRUE, Show=FALSE);

  if _existingVertices = [] then
    warning("No vertex weight to be changed.");
  else
    if domtype(VertexWeights) = DOM_TABLE then
      for x in _existingVertices do 
        if VertexWeights[x] = hold(None) then
          if _vertexWeights <> FAIL and contains(_vertexWeights, x) then
            delete _vertexWeights[x];
          end_if;
        else
          _vertexWeights[x] := VertexWeights[x];
        end_if;
      end_for;
    else
      for x in _existingVertices do
        position := contains(Vertex, x);
        // just overwrite the predefined weight or create a new one if not defined before.
        if VertexWeights[position] = hold(None) then
           // remove vertex from list, because it is not neccessary.
            if _vertexWeights <> FAIL and contains(_vertexWeights, x) then
               delete _vertexWeights[op(x,1)];
            end_if;
        else
          _vertexWeights[x] := VertexWeights[position]; 
        end_if;
      end_for;
    end_if;
  end_if;

  subsop(G, 3=_vertexWeights);
end_proc:

// End of file
null():

