/*-
 topSort - topological sorting of a Graph
 topSort(G)
 Parameters:
   G - Graph
-*/
Graph::topSort := proc(G)
local indeg, outdeg, i, j, _vertices, _edgesEntering, _edgesLeaving, 
      _number, Q, _result, _parent, predecessor;
begin
  Graph::graphCheck(G);

  if not Graph::isDirected(G) then
    error("The graph must be directed and acyclic to create a topological sorting.")
  end_if;

  _vertices := Graph::getVertices(G);
  _edgesEntering := Graph::getEdgesEntering(G);
  _edgesLeaving := Graph::getEdgesLeaving(G);

  indeg := Graph::inDegree(G);
  outdeg := Graph::outDegree(G);

  _number := 0;
  Q := [];
  // First all single vertices
  for i in _vertices do
    _parent[i] := infinity;
    if (indeg[i] = 0) and (outdeg[i] = 0) then
      _number := _number + 1;
      _result[_number] := i;
    end_if;
  end_for;

  // Now all the vertices with no indegree (circles are not allowed !)
  for i in _vertices do
    if (indeg[i] = 0) and (outdeg[i] > 0) then
      Q := append(Q,i);
    end_if;   
  end_for;

  /*-
   G contains cycle if there isn't any node with indeg[i] = 0 and outdeg[i] > 0
  -*/
  if nops(Q) = 0 then
    error("The graph contains at least one cycle or is empty.");
  end_if;

//  predecessor := Q[1];

  repeat
    i := Q[1];
    predecessor := i;
    delete Q[1];
    _number := _number + 1;
    _result[_number] := i;
    if _parent[i] = infinity then
      _parent[i] := predecessor;    	
    end_if;
    for j in _edgesLeaving[i] do
      indeg[j] := indeg[j] - 1;
      if _parent[j] = infinity then
        _parent[j] := i;      	
      end_if;
      if indeg[j] = 0 then        
        Q := append(Q, j);
      end_if;
    end_for;
  until Q = [] end_repeat;

  if _number < nops(_vertices) then
    error("The graph contains at least one cycle.");
  end_if;
  
  for i in _result do
    userinfo(NoNL, 1, "Vertex " . expr2text(rhs(i)) . " is used at timestamp " . expr2text(lhs(i)) . "\n" );    
  end_for;
  [_result, _parent];
end_proc:

// End of file
null():
