/*--
basis - returns non-reduced Gr"obner-basis for polynomials in list S

basis(S)

S - list of polynomials
o - term ordering
monic - normalizing functoion 

This is algorithm 5.8 (GR"OBNERNEW2) of Becker et al (p232). The only
difference is that any reduced S-polynomials (even redundant ones) are 
used in further reductions.

The "sugar cube" selection strategy is used to select critical pairs.
A sugared polynomial is represented as a list containing of:-
 - the polynomial p,
 - the leading term of p,
 - the sugar of p.
--*/

groebner::basis:=
proc(S, o, monic, gplus)
  local G, P, h, n;
begin
  // sort S
  S:= map(S, (s->([s, lterm(s, o), degree(s)])));
  n:= nops(S);
  if n <= 1 then
    return(S)
  end_if;
  S:= sort(S, ((a, b)->(not groebner::term_less(a,b,o))));

  // build initial pair list
  P:= [];
  G:= [S[1]];
  for h from 2 to n do
    [P, G]:= [groebner::update(P, G, S[h], o)];
  end_for;

  // create reducing set
  S:= [];
  for h in G do
    if degree(h[2]) = 0 then return([h]) end_if;
    S:= groebner::redset_insert(S, h)
  end_for;
  
  // do reductions
  while nops(P) <> 0 do
    userinfo(2,"remains ".nops(P)." crit. pairs, with ".nops(G)." polynomials");
    // select the minimal critical pair
    h:= groebner::s_poly(P[1],o, gplus);
    delete P[1];
    if iszero(h[1]) then next end_if;
    
    h:= groebner::reduce(h, S, o, gplus);
    if not iszero(h[1]) then
      h[1]:= monic(h[1],o);
      if iszero(h[1]) then
        // h can have turned out to be zero here by normalization
        next
      end_if;
      if degree(h[2]) = 0 then
        userinfo(2, "Found constant remainder on reduction");
        return([h])
      end_if;
      P:= groebner::update(P, G, h, o);
      G:= P[2];
      P:= P[1];
      S:= groebner::redset_insert(S, h);
    end_if;
  end_while;
  userinfo(2,"no more critical pair");
  G
end_proc:

// end of file 
