/*
 groebner::factor(l) takes as input a list of polynomials (for example
	the output of groebner::gbasis) describing a variety, and factors
	the variety if possible.
 Input: a list of polynomials
 Output: a set of list of polynomials
*/

// rewritten 23/08/06  stefanw

groebner::factor :=
proc(ll, ord, reord)
  local i,p,n,l;
begin

  
  if args(0)=3 then
    // second argument must be Reorder
    if args(3) <> hold(Reorder) then
      error("Wrong type of second argument")
    end_if
  else
    reord:= null()
  end_if;
      
  if ll=[] then
    return({[]})
  end_if;
  n:=nops(ll);
  if type(ll[1])<>DOM_POLY then
    // to ensure the order of variables remains the same 
    l:=map(ll,poly,[op(indets(ll,PolyExpr))]);
  else
    l:=ll
  end_if;

 
// the following code is slower because the cartesian product
// can be large:  
/*
  ll:= map(ll, factor);
  ll:= map(ll, x -> {op(x, 2*i) $i=1..nops(x) div 2});

  p:= combinat::cartesianProduct(op(ll));
  {op(map(p, groebner::gbasis, ord, reord))}
*/  
  
  
  for n from nops(ll) downto 1 do
    p:= l[n];    
    p:= coerce(factor(p), DOM_LIST);
    if nops(p)=1 then
      // degree = 0
      assert(not iszero(op(p, 1)));
      return({})
    end_if;
    if nops(p) = 3 then
      next
      // irreducible
    end_if;
    return(_union(groebner::factor(groebner::gbasis(subsop(l, n = op(p, 2*i)),
                                             ord, reord), ord, reord)
    $i=1..nops(p) div 2))
  end_for;
  return({ll})

end_proc:
