/*--
groebner::pair_less -- compare critical pairs p and q using ordering

groebner::pair_less(p,q,o)

p,q - critical pairs
o   - term ordering

pair_less returns TRUE iff p is strictly less than q. This defines
the selection strategy.

The order implemented here uses the sugar of the S-polynomials of the pairs
first. If the S-polynomials of the pairs have equal sugar the term ordering
of the lcm's of the leading terms of the pairs is used to order the pairs.
--*/

groebner::pair_less:=
proc()
  begin
    if args(1)[4] = args(2)[4] then
        bool(lmonomial(op(args(1),3)+op(args(2),3), args(3)) = op(args(2),3))
    else
        bool(args(1)[4] < args(2)[4])
    end_if
end_proc:

// end of file 
