/*++
s_poly -- returns sugared S-polynomial of critical pair
 
s_poly(p)
 
p - critical pair
o - term ordering

Used internally only, no error checking.
++*/

groebner::s_poly:= proc(p, o, gplus)
    local s;
begin
    s:= gplus(multcoeffs(divide(p[3], p[1][2], Exact), 
	lcoeff(p[2][1], o)) * p[1][1],
	- multcoeffs(divide(p[3], p[2][2], Exact), lcoeff(p[1][1],
	 o)) * p[2][1]);
    [ s, lterm(s, o), p[4] ]
end_proc:

// end of file 
