/*--
groebner::test_poly -- test if p is a polynomial over a field

groebner::test_poly(p)

p - polynomial to test

NOTE: If p is a polynomial over a domain we just assume that the domain
is a field.

The procedure returns an error if p is errorneous.
--*/

groebner::test_poly:= proc(p)
begin
  if domtype(p) <> DOM_POLY then 
     error("no polynomial");
  end_if;
  if domtype(op(p,3)) <> DOM_DOMAIN then
    if op(p,3) = hold(Expr) then
      // must have rational coeffs 
      if nops({DOM_INT,DOM_RAT} union map({coeff(p)}, domtype)) <> 2 then
         error("coefficients must be rational")
      end_if;
    else
      // must be IntMod(p) with prime p 
      if not isprime(op(p,[3,1])) then
         error("modulus must be a prime")
      end_if;
    end_if
  end_if;
end_proc:

// end of file 
