/*
   groebner::triangular_set(l) computes a triangular set for a list of
   polynomials defining a zero-dimensional ideal.

   Input: l is a list of n polynomials, where l[n] depends only on one
          variable x[n], l[n-1] on 2 variables x[n-1] and x[n], ...
   Output: a list of polynomials where l[k] is monic in x[k]

>> l:=[x*y-x*z+y^2+y^3+y^3*z+y^3*z^2+y^3*z^3,y+y^2+y^3+y^4+1,z+z^2+z^3+z^4+1]:
>> groebner::triangular_set(l,[x,y,z]);

              2    3    4             2    2      2  2    2  3
{[y - z, z + z  + z  + z  + 1], [x + y  + y  z + y  z  + y  z ,

                  2    3    2    3      2    2             2    3    4
   y + z + y z + y  + y  + z  + z  + y z  + y  z + 1, z + z  + z  + z  + 1]

   }
*/
groebner::triangular_set :=
proc(ll,XX,k)
  local c,t,g1,g2,i,l,X;
begin
  if args(0)<3 then
    if args(0)<2 then
      X:=op(ll[1],2)
    else
      X:=XX
    end_if;
    if type(ll[1])<>DOM_POLY then
      l:=map(ll,poly,XX)
    else
      l:=ll
    end_if;
    g1:=groebner::triangular_set(l,X,nops(l)-1);
    if type(args(1)[1])<>DOM_POLY then g1:=map(g1,map,expr) end_if;
    g1
  elif k=0 then
    {ll}
  else
    l:=ll;
    X:=XX;
    i:=min(op(map(indets(op(l[k],1)),(()->(contains(X,args(1))))) minus {0}));
    c:=lcoeff(poly(l[k],[X[i]]));
    if has(c,X) then
      t:=genident("t");
      g1:=groebner::gbasis(append(l,poly(c,X)),LexOrder);
      g1:=groebner::triangular_set(g1,X,nops(g1)-1);
      g2:=groebner::gbasis(map(append(l,poly(t*c-1,X)),poly,[t,op(X)]),
                           LexOrder);
      g2:=select(map(g2,poly,X),not has,t);
      if {op(l)}={op(g2)} then
        g2:={g2}
      else
        g2:=groebner::triangular_set(g2,X,nops(g2)-1);
      end_if;
      g1 union g2
    else
      groebner::triangular_set(l,X,k-1)
    end_if;
  end_if
end_proc:
