// 

DOM_INTERVAL::ceil :=
proc(a)
begin
  a := interval(a);
  if a::dom <> DOM_INTERVAL then
     if a = {} then return(a); end_if;
     return(FAIL);
  end_if;
  if op(a,0) = hold(_union) then
     return(_union(map(op(a), DOM_INTERVAL::ceil)));
  end_if;
  
  if op(a,0) = FAIL then
    // complex interval
    return(DOM_INTERVAL::ceil(Re(a))+I*DOM_INTERVAL::ceil(Im(a)));
  end_if;
  
  hull(map(op(a), ceil));
end_proc:

DOM_INTERVAL::floor := (a) -> -DOM_INTERVAL::ceil(-a):


DOM_INTERVAL::rhs :=
proc(iv)
begin
  iv := hull(iv);

  if iszero(Im(iv)) then
    op(iv, 2);
  else
    op(iv, [1,2]) + I*op(iv,[2,2]);
  end_if;
end_proc:

DOM_INTERVAL::lhs :=
proc(iv)
begin
  iv := hull(iv);

  if iszero(Im(iv)) then
    op(iv, 1);
  else
    op(iv, [1,1]) + I*op(iv,[2,1]);
  end_if;
end_proc:

DOM_INTERVAL::trunc := proc(a)
begin
  a := interval(a);
  if a::dom <> DOM_INTERVAL then
     if a = {} then return(a); end_if;
     return(FAIL);
  end_if;
  if op(a,0) = hold(_union) then
     return(_union(map(op(a), DOM_INTERVAL::trunc)));
  end_if;
  
  if op(a,0) = FAIL then
    // complex interval
    return(DOM_INTERVAL::trunc(Re(a))+I*DOM_INTERVAL::trunc(Im(a)));
  end_if;
  
  hull(map(op(a),
	   x ->
	   if x = RD_INF then
	     hull(RD_INF);
	   elif x = RD_NINF then
	     hull(RD_NINF);
	   else trunc(x); end_if));
end_proc:

DOM_INTERVAL::round := proc(a)
begin
  a := interval(a);
  if a::dom <> DOM_INTERVAL then
     if a = {} then return(a); end_if;
     return(FAIL);
  end_if;
  if op(a,0) = hold(_union) then
    return(_union(map(op(a), DOM_INTERVAL::round)));
  end_if;
  
  if op(a,0) = FAIL then
    // complex interval
    return(DOM_INTERVAL::round(Re(a))+I*DOM_INTERVAL::round(Im(a)));
  end_if;
  
  hull(map(op(a),
	   proc(x)
	     local i;
	   begin
	     i := round(x);
	     if i > 10^DIGITS then x+(-1...1) else i end_if;
	   end_proc));
end_proc:
