// 

// evaluation of a function over an interval

// internal function: rewrite a*b^(-1) to hold(_divide)(a, b)

interval::_divide :=
proc(a, b)
begin
  if indets(a) <> {} or indets(b) <> {} then
    procname(args());
  else
    _divide(args());
  end_if;
end_proc:

interval::_rewrite :=
proc(f, x)
  local num, den, ex, dummy;
begin
  case op(f, 0)
    of hold(_plus) do
      return(hold(_plus)(map(op(f), interval::_rewrite)));
      break;
    of hold(_power) do
      ex := op(f, 2);
      if testtype(ex, DOM_INT) and ex<0 then
        return(interval::_divide(1, op(f,1)^(-ex)));
      end_if;
      break;
    of hold(_mult) do
      [den, num, dummy] := split([op(f)], x->_lazy_and(testtype(x, "_power"),
                                                       testtype(op(x,2), DOM_INT),
                                                       op(x,2)<0));
      assert(dummy = []);
      if den <> [] then
        den := map(den, x->op(x,1)^(-op(x,2)));
        return(interval::_divide(_mult(op(num)), _mult(op(den))));
      end_if;
      break;
  end_case;
  return(f);
end_proc:
        
interval::evalSimple :=
proc(f)
begin
  interval(subs(interval::_rewrite(f), args(2..args(0)),Unsimplified));
end:

interval::evalMean :=
proc(f, xiv, x0)
  local x, iv, T, Tf, simple;
begin

  [x, iv] := [op(xiv)];
  
  if op(iv, 0) = hold(_union) then
    return(_union(op(map([op(iv)],
                         i -> interval::evalMean(f, x=i,
                                                 args(3..args(0)))))));
  end_if;
  if iv = {} then return(iv); end_if;

  // TODO: What should evalMean do when there are branch cuts?
  // As a first precaution, try to detect them heuristically:
  simple := interval::evalSimple(f, xiv);
  if op(simple, 0) = hold(_union) then
    // definitely hit a branch cut.  return a reliable value:
    return(simple);
  end_if;
  
  if args(0) < 4 then
    x0 := DOM_INTERVAL::center(iv);
  end_if;

  f := interval::_rewrite(f);
  
  T := interval::Taylor(2, x, iv);
  Tf := T(f);

  // overestimation bound (Neumair, p. 55):
  // 2*DOM_INTERVAL::width(Tf[1])*DOM_INTERVAL::width(iv)
  
  interval(subs(f, x=hull(x0), Unsimplified)) + Tf[1]*(iv - x0);
end_proc:

interval::evalSlope :=
proc(f, xiv, x0)
  local x, iv, fs, retval, simple;
begin
  [x, iv] := [op(xiv)];
  
  if op(iv, 0) = hold(_union) then
    return(_union(op(map([op(iv)],
                         i -> interval::evalSlope(f, x=i,
                                                  args(3..args(0)))))));
  end_if;
  if iv = {} then return(iv); end_if;

  // TODO: What should evalSlope do when there are branch cuts?
  // As a first precaution, try to detect them heuristically:
  simple := interval::evalSimple(f, xiv);
  if op(simple, 0) = hold(_union) then
    // definitely hit a branch cut.  return a reliable value:
    return(simple);
  end_if;
  
  if args(0) < 4 then
    x0 := DOM_INTERVAL::center(iv);
  end_if;

  if x = `# #x` then
    x = genident(`# #x`);
    f := subs(f, `# #x` = x, Unsimplified);
  end_if;
  
  fs := normal((f-subs(f, x=`# #x`))/(x-`# #x`));

  f := interval::_rewrite(f);
  fs := interval::_rewrite(fs);
  
  // same overestimation bound as above

  x0 = hull(x0);
  if traperror((retval :=
                interval(subs(f, x=x0, Unsimplified)
                         + subs(fs, [x=iv, `# #x`=x0], Unsimplified)*(iv-x0)))) = 0
    then retval
  else
    interval::evalMean(f, x, iv, x0);
  end_if;
end_proc:

interval::evalBiCentered :=
proc(f, xiv)
  local x, iv, T, Tf, zl, zr, p;
begin
  // TODO: Check that iv is DOM_INTERVAL!
  [x, iv] := [op(xiv)];
  
  if op(iv, 0) = hold(_union) then
    return(_union(op(map([op(iv)],
                         i -> interval::evalBiCentered(f, x=i,
                                                       args(3..args(0)))))));
  end_if;
  if iv = {} then return(iv); end_if;

  T := interval::Taylor(2, x, iv);
  Tf := T(f);

  p := [DOM_INTERVAL::center(Tf[1]),
    DOM_INTERVAL::width(Re(Tf[1])) + I*DOM_INTERVAL::width(Im(Tf[1]))];
  if iszero(p[2]) or contains(p, RD_INF)<>0 then
    return(interval::evalSlope(f, x=iv));
  end_if;
  
  if iszero(Im(p[2])) then
    p := Re(p[1])/Re(p[2]);
    if abs(p) > 1 then p := sign(p); end_if;

    p := p * DOM_INTERVAL::width(Re(iv))/2;
  elif iszero(Re(p[2])) then
    p := Im(p[1])/Im(p[2]);
    if abs(p) > 1 then p := sign(p); end_if;

    p := p * DOM_INTERVAL::width(Im(iv))/2 * I;
  else
    p := [Re(p[1])/Re(p[2]), Im(p[1])/Im(p[2])];
    if abs(p[1]) > 1 then p[1] := sign(p[1]); end_if;
    if abs(p[2]) > 1 then p[2] := sign(p[2]); end_if;
    
    p := (p[1]*DOM_INTERVAL::width(Re(iv))
          + p[2]*DOM_INTERVAL::width(Im(iv))*I)/2;
  end_if;
  zl := DOM_INTERVAL::center(iv) - p;
  zr := DOM_INTERVAL::center(iv) + p;

  if not zl in iv then
    zl := lhs(iv);
  end_if;
  
  if not zr in iv then
    zr := rhs(iv);
  end_if;

  interval::evalSlope(f, x=iv, zl)
  intersect interval::evalSlope(f, x=iv, zr);
  
end_proc:



// TODO: Symbolic simplification.
//  E.g.,
// >> f
// 
//                                      1
//                                ------------
//                                 2
//                                x  - 2 x + 1
// >> eval(subs(f, x=2...3)), eval(subs(expr(factor(f)), x=2...3))
// 
//        RD_NINF ... -1.0 union 0.1666666666 ... RD_INF, 0.25 ... 1.0
//
// But factor is not always the best idea. x^2-2*x should be written
// as (x+1)^2-1, not as x*(x-2).
//
// >> f1 := 1/(1-x+x^2):
// >> f2 := 4/((2*x-1)^2+3):
// >> normal(f1-f2)
// 
//                                      0
// >> eval(subs(f1, x=0...1), subs(f2, x=0...1))
// 
//                     0.5 ... RD_INF, 1.0 ... 1.333333334

// also, consider sin(x)/x for x=-1...1.  The function is extremely
// well-behaved, but nave interval evaluation leads to RD_NINF...RD_INF.

null():
