// 

// interval::_gauss_seidel performs a single Gauss-Seidel
// iteration step, contracting the solution of a linear
// system of equations.

interval::_gauss_seidel :=
proc(A, b, x)
  local i, k, n, y;
begin
  if b::dom::hasProp(Cat::Matrix)=TRUE then
    b := expr(b);
  end_if;
  if b::dom = DOM_ARRAY then
    if op(b,[0,1]) = 2 then
      if op(b,[0,3]) <> 1..1 then
        error("not yet implemented: b must have only one coloumn");
      end_if;
    end_if;
    b := [op(b)];
  end_if;
  if b::dom = DOM_LIST then
    n := nops(b);
  else
    error("not yet implemented: b must be an array or list");
  end_if;
       
  y := [0$n];
  for i from 1 to n do
    if iszero(A[i,i]) then
      if 0 in b[i] then
        y[i] := interval(x[i]);
      else
        y[i] := {};
      end_if;
    else
      y[i] := eval(((b[i]
                     - _plus(interval(A[i,k]*y[k])$k=1..i-1)
                     - _plus(interval(A[i,k]*x[k])$k=i+1..n)) / interval(A[i,i]))
                   intersect interval(x[i]));
    end_if;
  end_for;
  y;
end_proc:

// iterate until convergence has been achieved
// terminates because of finite precision.
interval::GaussSeidel :=
proc(A, b, x)
  local last_x, C, CA, Cb, Acenter;
begin
  C :=  FAIL;
  A := map(A, interval);
  Acenter := map(A, DOM_INTERVAL::center);
  if has(Acenter, FAIL) then
    return(FAIL);
  end_if;
  if not has(Acenter, RD_INF) and not has(Acenter, RD_NINF) then
    C := numeric::inverse(Acenter);
  end_if;
  if C <> FAIL then
    CA := expr(matrix(C) * matrix(A));
    Cb := expr(matrix(C) * matrix(b));
  else
    [CA, Cb] := interval::_pivot_maxdiag(A,b);
//    Acenter := map(A, rhs@interval);
//    if not has(Acenter, RD_INF) and not has(Acenter, RD_NINF) then
//      C := numeric::inverse(Acenter);
//    end_if;
//    if C = FAIL then
//      [CA, Cb] := interval::_pivot_maxdiag(A,b);
//    else
//      CA := expr(matrix(C) * matrix(A));
//      Cb := expr(matrix(C) * matrix(b));
//    end_if;
  end_if;
  last_x := map(x, _mult, 2);
  while x <> last_x and contains(x, {})=0 do
    last_x := x;
    x := eval(map(interval::_gauss_seidel(CA, Cb, x), eval));
  end_while;
  x;
end_proc:
