// combine matrices encoding conditions on parametric RDE, where
// the first m columns of A and B refer to the same coefficients,
// all columns after them are independent of one another.
// I.e., all columns of B after column m are shifted to the right
// far enough that they are outside of the size of A and then the
// matrices are stacked vertically. I.e., return C such that
// A * transpose(c1, ..., cm, d1, ..., dn) = 0 and
// B * transpose(c1, ..., cm, e1, ..., er) = 0 if and only if
// C * transpose(c1, ..., cm, d1, ..., dn, e1, ..., er) = 0.

// The matrices are given as hashes, with the entries "rows" and
// "cols" determining the size of the matrix, and "m" denoting
// the number of free coefficients in the rhs of the parametric
// RDE. "m" must match in the inputs.

intlib::algebraic::rde::combineHashMatrices :=
proc(A, B)
  local e, i, j, v, offset;
begin
  assert(A["m"] = B["m"]);
  assert(A["cols"] >= A["m"]);
  assert(B["cols"] >= B["m"]);

  offset := A["cols"] - A["m"];
  
  for e in B do
    [i, v] := [op(e)];
    if domtype(i) = DOM_STRING then next; end_if;
    
    // e = ((i, j) = v)
    [i, j] := [op(i)];
    if j > B["m"] then
      j := j + offset;
    end_if;
    A[i + A["rows"], j] := v;
  end_for;
  A["cols"] := A["cols"] + B["cols"] - A["m"];
  A["rows"] := A["rows"] + B["rows"];
  A;
end_proc:
