// Given a derivation D on k[t] and a,b,c in k[t] with a<>0,
// return n in Z_ such that deg(q) <= n for any solution
// q in k[t] of a*D(q)+b*q=c.

// Combines the algorithms from chapter 6.3 of
// Bronstein, Symbolic Integration I

intlib::algebraic::rde::degreeBound :=
proc(a, b, c, ts, diffs, algs)
  local dt;
begin
  if nops(ts) = 1 then
    return(intlib::algebraic::rde::boundDegreeBase(a, b, c));
  end_if;
  dt := poly(diffs[-1], [ts[-1]]);
  if degree(dt)=0 then
    return(intlib::algebraic::rde::boundDegreePrim(a, b, c, ts, diffs, algs));
  end_if;
  if degree(dt)=1 and iszero(coeff(dt, 0)) then
    return(intlib::algebraic::rde::boundDegreeExp(a, b, c, ts, diffs, algs));
  end_if;
  if degree(dt)>1 then
    return(intlib::algebraic::rde::boundDegreeNonlinear(a, b, c, ts, diffs, algs));
  end_if;
  infinity;
end:
