// Bound on polynomial solutions of the parametric Risch DE -- hyperexponential case

// given a, b, q[1], ..., q[m] in k[t], with t primitive over k, a<>0,
// return n in Z_ such that degree(q) <= n for any solution q in k[t] and 
// c[1], ..., c[m] in k of a*d(q)+b*q=sum(c[i]*q[i], i=1..m).

// Follows Bronstein, Symbolic Integration I, p. 228

intlib::algebraic::rde::parametricBoundDegreePrim :=
proc(a, b, q, ts, diffs, algs)
  local da, db, dc, m, n, alpha, beta, z, w, d;
begin
  assert(not has(diffs[-1], [ts[-1]]));
  da := degree(a);
  db := degree(b);
  dc := max(map(q, degree));
  if db>da then
    n := max(0, dc - db);
  else
    n := max(0, dc -da + 1);
  end_if;
  if da-1 = db then // possible cancellation
    alpha := intlib::algebraic::normal(-lcoeff(b)/lcoeff(a), [ts[-2]]);
    [w, m] := intlib::algebraic::limitedIntegrate(alpha[1], alpha[2],
      [intlib::algebraic::normal(diffs[-1], [ts[-2]])], ts[1..-2], diffs[1..-2], algs[1..-2]);
    if w <> FAIL and testtype(m[1], DOM_INT) then
      n := max(n, m[1]);
    end_if;
  elif da=db then // possible cancellation
    alpha := intlib::algebraic::normal(-lcoeff(b)/lcoeff(a), [ts[-2]]);
    z := intlib::algebraic::logarithmicDerivative(alpha[1], alpha[2], ts[1..-2], diffs[1..-2], algs[1..-2]);
    if z <> FAIL then
      d := intlib::algebraic::diff(ts, diffs, algs);
      beta := intlib::algebraic::normal(-lcoeff(expr(a)*d(z) + expr(b)*z, [ts[-1]])
        /(z*lcoeff(a)), [ts[-2]]);
      if iszero(beta[1]) then
        beta := intlib::algebraic::normal(
          -lcoeff(expand(expr(a)*d(z) + expr(b)*z), [ts[-1]])
          /(z*lcoeff(a)), [ts[-2]]);
      end_if;
      [w, m] := intlib::algebraic::limitedIntegrate(beta[1], beta[2],
        [intlib::algebraic::normal(diffs[-1], [ts[-2]])], ts[1..-2], diffs[1..-2], algs[1..-2]);
      if w <> FAIL and testtype(m[1], DOM_INT) then
        n := max(n, m[1]);
      end_if;
    end_if;
  end_if;
  return(n);
end:
