// parametric RDE -- polynomial case

// Given a derivation d on k(t), b, q1,...,qm in k[t], and n in Z_, n>0,
// find f1,...,fn in k[t] and a matrix (a hash) A with entries in
// Const(k) such that, whenever q in k[t] and c1,...,cm in Const(k)
// satisfy d(q)+b*d=sum(c[i]*q[i]) and degree(q)<=n, then
// q = sum(d[i]*f[i]) where d1,...,dn in Const(k) and
// A*transpose([c1,...,cm,d1,...dn])=0.

// Follows Bronstein, Symbolic Integration I, pp.233-245

intlib::algebraic::rde::parametricPolyRDE :=
proc(b : DOM_POLY, q : DOM_LIST, n : DOM_INT, ts, diffs, algs)
  local f, A, db, dt;
begin
  if nops(ts) = 1 then
    // d = d/dt
    if iszero(b) then
      [f, A] := intlib::algebraic::rde::parametricPolyRDENoCancel2a(b, q, n, ts, diffs, algs);
    else
      [f, A] := intlib::algebraic::rde::parametricPolyRDENoCancel1(b, q, n, ts, diffs, algs);
    end_if;
  else
    dt := degree(diffs[-1], [ts[-1]]);
    db := degree(b);
    if not iszero(b) and db > max(0, dt-1) then
      [f, A] := intlib::algebraic::rde::parametricPolyRDENoCancel1(b, q, n, ts, diffs, algs);
    elif dt >= 2 and db < dt - 1 then
      [f, A] := intlib::algebraic::rde::parametricPolyRDENoCancel2(b, q, n, ts, diffs, algs);
    elif dt >= 2 and db = dt - 1 then
      [f, A] := intlib::algebraic::rde::parametricPolyRDENoCancel3(b, q, n, ts, diffs, algs);
    elif dt <= 1 then
      assert(db = 0);
      [f, A] := intlib::algebraic::rde::parametricPolyRDECancelLiouville(b, q, n, ts, diffs, algs);
    else
      error("logic error");
    end_if;
  end_if;
  return([f, A]);
end_proc:
