// Given a derivation d on k[t], n in Z_ and b, q1, ..., qm in k[t] with
// b<>0 and either d = d/dt or degree(b) > max(0, degree(d(t))-1), return
// h1,...,hr in k[t] and a matrix (a hash) A with coefficients in Const(k)
// such that if c1,...,cm in Const(k) and q in k[t] satisfy degree(q)<=n
// and d(q)+b*q=sum(c[i]*q[i]) then q=sum(d[j]*h[j]) where d[1],...,d[r] in
// Const(k) and A*transpose([c1,...,cm,d1,...,dr])=0

// Follows Bronstein, Symbolic Integration I, p. 234

intlib::algebraic::rde::parametricPolyRDENoCancel1 :=
proc(b : DOM_POLY, q : DOM_LIST, n, ts : DOM_LIST, diffs : DOM_LIST, algs : DOM_LIST)
  local degb, lcb, h, s, i, j, m, d, degq, A, u, A2;
begin
  assert(nops(ts)=1 or degree(b)>max(0, degree(diffs[-1], [ts[-1]])-1));
  d := intlib::algebraic::diff(ts, diffs, algs);
  degb := degree(b);
  lcb := lcoeff(b);
  m := nops(q);
  h := [poly(0, [ts[-1]]) $ m];
  while n>=0 do
    for i from 1 to m do
      s := poly([[coeff(q[i], n+degb)/lcb, n]], [ts[-1]]);
      h[i] := h[i] + s;
      q[i] := q[i] - d(s) - b*s;
    end_for;
    n := n-1;
  end_while;
  // By now, we only need to simplify the constraints
  // sum(c[i]*q[i])=0
  if _and(op(map(q, iszero))) then
    degq := -1; // MuPAD uses degree(poly(0, [t]))=0, but we want to treat 0 differently from 1
    A := table(0);
    A["m"] := m;
    A["cols"] := 2*m;
    A["rows"] := m;
    for i from 1 to m do
      A[i, i] := 1;
      A[i, i+m] := -1;
    end_for;
  else
    degq := max(op(map(q, degree)));
    A := table(0);
    A["m"] := m;
    A["rows"] := degq+1;
    A["cols"] := m;
    for i from 0 to degq do
      for j from 1 to m do
        A[i+1, j] := coeff(q[j], i);
      end_for;
    end_for;
    [A2, u] := intlib::algebraic::rde::constantSystem(A, [0$(degq+1)], ts, diffs, algs);
    A := table(0);
    A["m"] := m;
    A["cols"] := 2*m;
    A["rows"] := m;
    for i from 1 to m do
      A[i, i] := 1;
      A[i, i+m] := -1;
    end_for;
    A := intlib::algebraic::rde::combineHashMatrices(A, A2);
  end_if;
  return(intlib::algebraic::rde::simplifyHashMatrix(h, A));
end_proc:
