// Given k[t] with Const(k)=k, d=d/dt, n in Z_ and b, q1, ..., qm in k[t] with
// degree(b) = 0, return h1,...,hr in k[t] and a matrix (a hash) A with 
// coefficients in Const(k) such that if c1,...,cm in Const(k) and q in k[t] 
// satisfy degree(q)<=n and d(q)+b*q=sum(c[i]*q[i]) then q=sum(d[j]*h[j]) 
// where d[1],...,d[r] in Const(k) and A*transpose([c1,...,cm,d1,...,dr])=0

// Note: This is an “if,” not an “iff.”

// Special case of Bronstein, Symbolic Integration I, p. 236 ff.

intlib::algebraic::rde::parametricPolyRDENoCancel2a :=
proc(b : DOM_POLY, q : DOM_LIST, n, ts : DOM_LIST, diffs : DOM_LIST, algs : DOM_LIST)
  local t, m, h, A, i;
begin
  assert(iszero(b));
  assert(nops(ts)=1 and diffs[1]=1 and algs=[[]]);

  t := ts[-1];
  m := nops(q);
  
  // h' = q
  h := map(q,
    p -> poly(map(poly2list(p), l -> [l[1]/(l[2]+1), l[2]+1]), op(p, 2..3))).
    [poly(1, [t])];
  A := table(0);
  A["m"] := m;
  A["cols"] := 2*m+1;
  A["rows"] := m;
  for i from 1 to m do
    A[i, i] := 1;
    A[i, i+m] := -1;
  end_for;
  return(intlib::algebraic::rde::simplifyHashMatrix(h, A));
end_proc:
