// weak normalizer (in the context of the Risch DE)
//
// Given a derivation d on k[t] and f in k(t),
// return q in k[t] such that f-d(q)/q is weakly
// normalized w.r.t. t.
// Following Bronstein, Symbolic Integration I, p. 183

intlib::algebraic::rde::weakNormalizer :=
proc(fNum, fDen, ts, diffs, algs)
  local dn, ds, g, z, dAst, d1, dd1, a, b, r, rr, n, done;
begin
  [dn, ds] := intlib::algebraic::splitFactor(fDen, ts, diffs, algs);
  g := gcd(dn, dn');
  dAst := divide(dn, g, Quo); // Exact
  d1 := divide(dAst, gcd(dAst, g), Quo); // Exact
  if degree(d1)=0 then
    return(poly(1, op(fNum, 2)));
  end_if;
  [a,b] := intlib::algebraic::extendedEuclidean(divide(fDen, d1, Quo), // Exact
                     d1, fNum);
  z := solvelib::getIdent(Any, indets({coeff(fNum), coeff(fDen), ts, diffs, algs}));
  dd1 := intlib::algebraic::diff(ts, diffs, algs)(d1);
//  print([a - multcoeffs(dd1, z), d1]);
  if traperror((
    r := polylib::resultant(a - multcoeffs(dd1, z), d1)),
    MaxSteps = intlib::subresMaxSteps(a, d1)) <> 0 then
    error("resultant computation took too long"); // caught above
  end_if;
  // simplify r before converting to polynomial -- saves time and we are only looking for integer roots
  done := FALSE;
  while not done do
    case type(r)
    of "_power" do
      if domtype(op(r, 2)) = DOM_INT then
        r := op(r, 1);
      else
        done := TRUE;
      end_if;
      break;
    of "_mult" do
      r := select(r, _not@testtype, Type::Constant);
      if type(r) = "_mult" then
        done := TRUE;
      end_if;
      break;
    otherwise
      done := TRUE;
    end_case;
  end_while;
  rr := intlib::algebraic::integerRoots(poly(r, [z]));
//  if rr = FAIL then return(FAIL); end_if;
  if rr = FAIL then
    n := {};
  else
    n := select(rr, n -> n>0);
  end_if;
  if n = {} then
    return(poly(1, op(fNum, 2)));
  end_if;
  return(_mult(op(map(n, n -> gcd(a-multcoeffs(dd1, n), d1)^n))));
end:
