// canonical representation
// Given a derivation d on k[t] and f in k(t), return
// [fp, fs, fn] (fp in k[t], fs and fn in k(t)) is the
// canonical representation of f wrt d, f =fp+fs+fn.

// Follows Bronstein, Symbolic Integration I, p. 103

intlib::algebraic::canonicalRepresentation :=
proc(fnum, fden, ts, diffs, algs)
  local t, q, r, dn, ds, tmp, b, c;
begin
  // we want a monic denominator
  tmp := lcoeff(fden);
  fnum := multcoeffs(fnum, 1/tmp);
  fden := multcoeffs(fden, 1/tmp);
  t := ts[-1];
  [q, r] := map([divide(fnum, fden)], mapcoeffs, normal, Expand = FALSE);
  [q, r] := map([q, r], intlib::algebraic::reduceModAlgebraics, ts, diffs, algs);
  [dn, ds] := intlib::algebraic::splitFactor(fden, ts, diffs, algs);
  [b, c] := intlib::algebraic::extendedEuclidean(dn, ds, r);
  // TODO: Could there be cancellation?
  [q, [b, ds], [c, dn]];
end_proc:
