// Bronstein versions of extended Euclidean algorithm

// Given a,b,c, with c in Ideal(a, b), return s, t s.t.
// s*a+t*b=c and either s=0 or degree(s)<degree(b)

proc()
  local seminormal, test0;
  option escape;
begin

seminormal := ex -> normal(ex, NoGcd, /*Rationalize = None, */Expand = FALSE);
test0 :=
proc(p)
  local c;
begin
  for c in [coeff(p)] do
    if testeq(c, 0, Goal=TRUE) <> TRUE then
      return(FALSE);
    end_if;
  end_for;
  TRUE;
end;


intlib::algebraic::extendedEuclidean :=
proc(a,b,c)
  local s,t,g,q,r,F;
begin
  if iszero(c) then return([c, c]); end_if;
  // very frequent special case: c is a multiple of a or b
  if test0(divide(c, b, Rem)) then
    return([c-c, mapcoeffs(divide(c, b, Quo), normal)]);
  end_if;
  if test0(divide(c, a, Rem)) then
    return([mapcoeffs(divide(c, a, Quo), normal), c-c]);
  end_if;
  
  [g,s,t] := [gcdex(a, b)]; // g = s*a+t*b
  [q, r] := [divide(c, g)];
  if testargs()=TRUE then
    if not iszero(mapcoeffs(r, seminormal)) then
      error("c is not in the ideal generated by a and b");
    end_if;
  end_if;
  // There is not a single example in the int test files
  // where using Dom::ExpressionField is faster!
  if FALSE and nops(indets(expr({args()}))) = 1 then
    F := Expr;
  else
    F := Dom::ExpressionField(seminormal, iszero);
  end_if;
  s := poly(q*s, op(s, 2), F);
  t := poly(q*t, op(t, 2), F);
  b := poly(b, op(b, 2), F);
  a := poly(a, op(b, 2), F);
  if not iszero(s) and degree(s) >= degree(b) then
    [q, r] := [divide(s, b)];
    s := r;
    t := t+q*a;
  end_if;
  map([s, t], poly, op(s, 2), Expr);
end:
end_proc():
