// assuming k=Q_(a,b,c,...), a finite extension of Q_,
// find all integral roots of f in k[t].
//
// The idea of the algorithm is to regard f as a rational
// function in one of a, b, c, ... and to look for
// common integral roots of all its numerator's coefficients.

intlib::algebraic::integerRoots :=
proc(f)
  local t, zeroes, inds, a, fa, coeffsFa, gcdOfCoeffs;
begin
  if iszero(f) then return(FAIL); end_if;
  f := mapcoeffs(multcoeffs(f, 1/lcoeff(f)), normal);
  if map({coeff(f)}, testtype, Type::Constant) = {TRUE} 
    and not has({coeff(f)}, I) then
    zeroes := polylib::realroots(f, 1/10);
    zeroes := map(zeroes,
      z -> if iszero(f(round((z[1]+z[2])/2))) then round((z[1]+z[2])/2) else null() end_if);
    return({op(zeroes)});
  end_if;
  
  t := op(f, 2);
  inds := numeric::indets({coeff(f)});
  repeat
    if inds = {} then
      return(FAIL);
    end_if;
    a := op(inds, 1);
    inds := inds minus {a};
    fa := intlib::algebraic::normal(expr(f), [a]);
  until fa <> [FAIL, FAIL] end_repeat;
  coeffsFa := {coeff(fa[1])};
  coeffsFa := map(coeffsFa, c -> poly(/*numer*/(c), t));
  gcdOfCoeffs := gcd(op(coeffsFa));
  intlib::algebraic::integerRoots(gcdOfCoeffs);
end:
