// Integration of polynomials in a primitive extension

// With t a primitive monomial over k and p in k[t], return
// q in k[t] and a Boolean b such that, if b=TRUE, p-D(q) in k
// and, if b=FALSE, p does not have an elementary integral over k(t).

// Follows Bronstein, Symbolic Integration I, p. 158

intlib::algebraic::integratePrimitivePolynomial :=
proc(p, ts, diffs, algs)
  local t, b, c, m, q0, q, good;
begin
  p := mapcoeffs(p, normal);
  p := mapcoeffs(p, intlib::algebraic::reduceModAlgebraics, ts, diffs, algs);
  if iszero(degree(p)) then
    return([0, TRUE]);
  end_if;
  t := ts[-1];
  if nops(ts)=1 then
    assert(diffs[1] = 1);
    b := poly2list(p);
    b := map(b, t -> [t[1]/(t[2]+1), t[2]+1]);
    return([poly(b, op(p, 2..3)), TRUE]);
  else
    [b,c] := intlib::algebraic::limitedIntegrate(op(intlib::algebraic::normal(lcoeff(p), [ts[-2]])),
                        [intlib::algebraic::normal(diffs[-1], [ts[-2]])],
                        ts[1..-2], diffs[1..-2], algs[1..-2]);
    if b=FAIL then
      return([0, FALSE])
    end_if;
    c := c[1];
  end_if;
  m := degree(p);
  q0 := poly([[c/(m+1), m+1], [b, m]], [t]);
  [q, good] := intlib::algebraic::integratePrimitivePolynomial
     (p-intlib::algebraic::diff(ts, diffs, algs)(q0), ts, diffs, algs);
  [q+q0, good];
end:
