// solve a very sparse system of linear equations, where usually
// the result vector is also very sparse
intlib::algebraic::linsolve :=
proc(eqs, ts)
  local zeroes, t, sol, inds, eqs2, cnt;
  save SEED;
begin
  // terms which are not sums are linear
  // in one indet., which is therefore zero
  eqs := select(eqs, _not@iszero);
  if length(eqs) > 1e5 or (length(eqs) > 1e4 and nops(ts) > 30) then
    return(FAIL);
  end_if;
  eqs := map(eqs, expr@poly, ts);
  if select(eqs, _not@has, ts) <> [] then
    // equation not zero, but does not depend on vars to solve for?
    return(FAIL);
  end_if;
  zeroes := {};
  while ((t := select(eqs, _not@has, [hold(_plus)]))) <> [] do
    t := map(t, eq -> numeric::indets(eq) intersect {op(ts)});
    t := select(t, e -> nops(e)=1);
    if nops(t) = 0 then break; end_if;
    t := map(t, e -> op(e)=0);
    zeroes := zeroes union {op(t)};
    eqs := subs(eqs, zeroes);
    eqs := select(eqs, _not@iszero);
    if select(eqs, _not@has, ts) <> [] then
      // equation not zero, but does not depend on vars to solve for?
      return(FAIL);
    end_if;
  end_while;

  if nops(eqs) = 0 then
    return([op(zeroes)]);
  end_if;
  if nops(eqs) > 42 then
    // many equations, free parameters -> numeric::linsolve tends to be slower
    // and often, the system has no solution anyway. First try with the
    // parameters replaced by some random values
    inds := numeric::indets(eqs) minus {op(ts)};
    if inds <> {} then
      SEED := 123;
      cnt := 0;
      while traperror((eqs2 := evalAt(eqs, map(inds, v -> v=(random() mod 321))))) <> 0 do
        cnt := cnt+1;
        if cnt > 5 then return(FAIL); end_if;
      end_while;
      if numeric::linsolve(eqs2, select(ts, t -> not has(zeroes, t)), 
                           Symbolic, NoWarning, Normal = (e -> normal(e, Expand=FALSE))) = FAIL then
        return(FAIL);
      end_if;
    end_if;
  end_if;
    
  sol := numeric::linsolve(eqs, select(ts, t -> not has(zeroes, t)), 
                           Symbolic, NoWarning, Normal = (e -> normal(e, Expand=FALSE)));
  if sol = FAIL then
    return(sol);
  end_if;
  [op(zeroes)].sol;
end:

