// normalize an element of K(x)(t)/<t^n-a> 
// with respect to a given integral basis created by 
// intlib::algebraic::simpleRadicalIntegralBasis.
// Note that such a basis always has entries of th form R*t^i,
// where R does not contain t.
//
// input: the fraction to normalize (nmerator and denominator),
// and the standard representation of the field tower
// it is not necessary to rationalize the denominator before calling this function.
//
// output: a list [[A_1, A_2, ...], D] such that 
// num/den = (A_1*w_1+A_2*w_2+...)/D, where [w_1, w_2, ...] is the integral basis

intlib::algebraic::normalizeAlgebraicFraction :=
proc(num, den, ts, diffs, algs)
  local t, x, a, n, w, term, g, A, i;
begin
  t := ts[-1];
  x := ts[-2];
  assert(algs[-1][1] = "simpleradical");
  n := algs[-1][2];
  a := algs[-1][3];
  w := algs[-1][4];
  num := divide(num, poly(t^n-a, [t]), Rem);
  den := divide(den, poly(t^n-a, [t]), Rem);
  if degree(den) > 0 then
    [num, den] := intlib::algebraic::rationalizeDenominator(num, den, ts, diffs, algs);
  end_if;
  // ensure den in K[x]:
  den := intlib::algebraic::normal(expr(den), [x]);
  num := multcoeffs(num, expr(den[2]));
  den := den[1];
  A := [0 $ n];
  for term in poly2list(num) do
    i := term[2]+1;
    assert(iszero(A[i]));
    assert(degree(w[i], [t]) = i-1);
    A[i] := term[1]/(w[i] | t=1);
  end_for;
  // ensure A[i] in K[x]:
  A := map(A, intlib::algebraic::normal, [x]);
  g := lcm(op(map(A, op, 2)));
  A := map(A, a -> a[1]*divide(g, a[2], Quo));
  den := den*g;

  // reduce mod other algebraics:
  for i from 2 to nops(algs)-2 do
    if algs[i] = [] then next; end_if;
    if algs[i][1] <> "simpleradical" then next; end_if;
    t := ts[i];
    [n, a] := algs[i][2..3];
    a := poly(t^n-a, [t]);
    A := map(A, mapcoeffs,
      proc(Ai)
      begin
        Ai := intlib::algebraic::normal(Ai, [t]);
        Ai := map(Ai, divide, a, Rem);
        expr(Ai[1])/expr(Ai[2]);
      end_proc);
    mapcoeffs(den,
      proc(Ai)
      begin
        Ai := intlib::algebraic::normal(Ai, [t]);
        Ai := map(Ai, divide, a, Rem);
        expr(Ai[1])/expr(Ai[2]);
      end_proc);
  end_for;
  if nops(algs) > 1 and nops(algs[-2]) > 0 and
    algs[-2][1] = "simpleradical" then
    t := ts[-2];
    [n, a] := algs[-2][2..3];
    a := poly(t^n-a, [t]);
    A := map(A, divide, a, Rem);
    den := divide(den, a, Rem);
  end_if;
  
  A := map(A, mapcoeffs, normal, Expand=FALSE);
  den := mapcoeffs(den, normal, Expand=FALSE);
  
  g := gcd(op(A), den);
  if degree(g) > 0 then
    A := map(A, divide, g, Quo);
    den := divide(den, g, Quo);

    A := map(A, mapcoeffs, normal, Expand=FALSE);
    den := mapcoeffs(den, normal, Expand=FALSE);
  end_if;
  [A, den];
end_proc:
