//
// polynomial reduction of polynomial in nonlinear monomial,
// i.e. p in k[t] such that degree(d(t), t) > 0.
//
// following Bronstein, Symbolic Integration I, p. 141

intlib::algebraic::polynomialReduce :=
proc(p, ts, diffs, algs)
  local t, dt, deg, m, q0, q, p1, r;
begin
  t := ts[-1];
  dt := poly(diffs[-1], [t]);
  assert(domtype(dt) = DOM_POLY and degree(dt) > 0);
  if dt = FAIL then // should never happen
    return([0, p]);
  end_if;
  deg := degree(dt);
  if degree(p) < deg then
    return([0, p]);
  end_if;
  m := degree(p) - deg + 1;
  q0 := poly([[lcoeff(p)/lcoeff(dt)/m,m]], [t]);
  p1 := mapcoeffs(p-intlib::algebraic::diff(ts, diffs, algs)(q0), normal);
  // Lemma 3.4.2 of Bronstein is wrong.
  // counterexample: diff(exp(-x)*exp(I*x), x) = (I-1)*exp(-x)*exp(I*x)
  // since polynomial reduction is optional, we can simply give up:
  if degree(p1) >= degree(p) then
    return([0, p]);
  end_if;
  [q, r] := intlib::algebraic::polynomialReduce(p1, ts, diffs, algs);
  [expr(q0)+q, r];
end:
