// rationalize denominator, i.e., remove an algebraic quantity from there
// by expanding the fraction
// 
// This is an extension of the third binomial theorem

intlib::algebraic::rationalizeDenominator :=
proc(num, den, ts, diffs, algs)
  local t, a, n, newden, newnum, invden;
begin
  t := ts[-1];
  assert(algs[-1][1] = "simpleradical");
  n := algs[-1][2];
  a := algs[-1][3];
  newden := (-1)^n*polylib::resultant(poly(den, [t]), poly(t^n-a, [t]), t);
  if n = 2 then
    newnum := num * poly(den | t=-t, [t]);
  else
    invden := [gcdex(den, poly(t^n-a, [t]))][2];
    newnum := multcoeffs(invden*num, newden);
  end_if;
  newnum := mapcoeffs(divide(newnum, poly(t^n-a, [t]), Rem), normal, Expand=FALSE);
  [newnum, newden];
end_proc:
