// Hermite reduction over simple radical field extensions
//
// Given a derivation on k(x)/<x^n-a> and f in k(x), return g,h,r in k(x)
// such that f=D(g)+h+r, h is simple and r is reduced.
//
// following Bronstein, Symbolic Integration Tutorial, ISSAC '98

intlib::algebraic::simpleRadicalHermite :=
proc(num, den, ts, diffs, algs)
  local n, a, w, wprime, Di, Dp, H, Hp, d, x, denFac, U, m, V,
        Vp, integral, fi, i, T, Q, A, Bi, Qi, R, g, one, r;
begin
  assert(algs[-1] <> [] and algs[-1][1] = "simpleradical");
  [n, a, w, wprime, Di, H] := algs[-1][2..7];

  [num, den] := intlib::algebraic::normalizeAlgebraicFraction(num, den, ts, diffs, algs);
  
  d := intlib::algebraic::diff(ts, diffs, algs);
  x := ts[-2];
  r := 0;
  
  denFac := coerce(polylib::sqrfree(den), DOM_LIST);
  if nops(denFac) = 1 then
    return([0, [poly(0, [ts[-1]]), poly(1, [ts[-1]])],
      [poly(`+`(op(zip(num, w, `*`))), [ts[-1]]), poly(den, [ts[-1]])]]);
  end_if;
  if denFac[1] <> 1 then
    num := map(num, multcoeffs, 1/denFac[1]);
  end_if;
  U := den;
  U := multcoeffs(den, 1/denFac[1]);
  U := mapcoeffs(U, intlib::algebraic::reduceModAlgebraics, ts, diffs, algs);
  U := mapcoeffs(U, normal, Expand=FALSE);
  delete denFac[1];
  
  // sort square-free factorization with decreasing degrees
  denFac := [[denFac[i+1], denFac[i]] $ i = 1..nops(denFac) step 2];
  denFac := revert(sort(denFac));
  
  Hp := d(expr(H))/expr(H);
  Dp := [0].map(Di, di -> d(expr(di))/expr(di));
  [m, V] := denFac[1];
  U := divide(U, V^m, Quo); // is exact
  U := mapcoeffs(U, intlib::algebraic::reduceModAlgebraics, ts, diffs, algs);
  V := expr(V);
  Vp := d(V);
  delete denFac[1];
  integral := 0;
  while m > 1 do
    if nops(denFac) > 0 and denFac[1][1] = m then
      V := V*expr(denFac[1][2]);
      Vp := d(V);
      U := mapcoeffs(divide(U, denFac[1][2]^m, Quo), normal, Expand=FALSE); // is exact
      U := mapcoeffs(U, intlib::algebraic::reduceModAlgebraics, ts, diffs, algs);
      delete denFac[1];
    end_if;
    fi := map(num, A -> normal(expr(A)/expr(U), Expand=FALSE));
    for i from 1 to n do
      if not iszero(fi[i]) then
        fi[i] := fi[i]/(V*((i-1)/n*Hp - Dp[i])-(m-1)*Vp);
      end_if;
    end_for;
    fi := map(fi, intlib::algebraic::normal, [x]);
    Q := lcm(op(map(fi, op, 2)));
    T := map(fi, f -> f[1]*divide(Q, f[2], Quo));
    [one, A, R] := [gcdex(V, expr(Q), x)];
    if one <> 1 then return([FAIL, [FAIL, FAIL], [FAIL, FAIL]]); end_if;
    Qi := map(T, Ti -> [divide(poly(R*Ti, [x]), poly(V, [x]))]);
    Bi := map(Qi, expr@op, 2);
    Qi := map(Qi, expr@op, 1);
    integral := integral + _plus(op(zip(Bi, expr(w), `*`)))/V^(m-1);
    // TODO: At this place, the problem naturally divides into three sub-problems,
    //       which should continue to be considered together, since the further
    //       handling of at least the second one will create another instance
    //       of a problem that can be fruitfully merged with the third one.
    // For the moment, split off last summand and call ourselves recursively:
    g := _plus(Qi[i]*wprime[i] $ i = 1..n)/V^(m-2);
    g := intlib::algebraic::normal(g, [ts[-1]]);
    Q := intlib::algebraic::normalizeAlgebraicFraction(g[1], g[2], ts, diffs, algs);
    if iszero(divide(U*V^(m-1), Q[2], Rem)) then
      g := map(Q[1], _mult, divide(U*V^(m-1), Q[2], Quo));
    else
      g := intlib::algebraic::simpleRadicalHermite(
        op(g), ts, diffs, algs);
      if g[1] = FAIL then return(g); end_if;
      integral := integral + g[1];
      assert(expr(g[2]) = [0, 1]);
      r := r + expr(g[3][1])/expr(g[3][2]);
      g := [0 $ n];
    end_if;
    num := map([
      poly(expr(A*num[i] - U*((m-1)*Vp*Qi[i]+d(Bi[i]))+g[i]), [x])
      $ i = 1..n
    ], mapcoeffs, normal, Expand=FALSE);
    m := m-1;
  end_while;
  if nops(denFac) > 0 then
    assert(1=denFac[1][1]);
    assert(iszero(mapcoeffs(U-denFac[1][2], normal, Expand=FALSE)));
    V := V*expr(denFac[1][2]);
  else
    assert(testeq(expr(U), 1));
  end_if;
  V := poly(V, [x]);
  g := gcd(op(num), V);
  if degree(g) > 0 then
    num := map(num, divide, g, Quo);
    V := divide(V, g, Quo);
  end_if;
  r := r + expr(`+`(op(zip(num, w, `*`))))/expr(V);
  [integral, [poly(0, [ts[-1]]), poly(1, [ts[-1]])],
   intlib::algebraic::normal(r, [ts[-1]])];
end_proc:
