// splitting-factorization of a polynomial w.r.t. a derivation:
// return ps*pn, s.t. ps is special and each squarefree factor of pn
// is normal
// Source: Bronstein, Symbolic Integration I, p. 100
intlib::algebraic::splitFactor :=
proc(p, ts, diffs, algs)
  local t, d, S, qn, qs;
begin
  t := ts[-1];
  if not has(p, t) then
    return([p, poly(1, [t])]);
  end_if;
  d := intlib::algebraic::diff(ts, diffs, algs);
  S := divide(gcd(p, d(p)), gcd(p, diff(p, t)), Quo); // exact division
  assert(iszero(mapcoeffs(divide(gcd(p, d(p)), gcd(p, diff(p, t)), Rem), normal)));
  if degree(S)=0 then
    return([p, poly(1,[t])]);
  end_if;
  assert(iszero(mapcoeffs(divide(p, S, Rem), normal)));
  [qn, qs] := intlib::algebraic::splitFactor(mapcoeffs(divide(p, S, Quo), normal), 
                       ts, diffs, algs);
  [qn, mapcoeffs(S*qs, normal)];
end:

