// splitting square-free factorization
// following Bronstein, Symbolic Integratino I, p. 102
//
// Given a derivation d on k[t] and p in k[t], return
// [n1,...,nm] and [s1,...,sm] in k[t]^m such that
// p=_mult(n[i]^i$i=1..m)*_mult(s[i]^i$i=1..m) is a splitting
// factorization and that all ni and si are squarefree
// and coprime.
intlib::algebraic::splitSquarefreeFactor :=
proc(p, ts, diffs, algs)
  local P, const, S, N;
begin
  P := polylib::sqrfree(p, "UseAlgebraicExtension");
  P := coerce(P, DOM_LIST);
  if nops(P) = 1 then
    return([[p], [poly(1, op(p, 2))]]);
  end_if;
  const := P[1];
  P := P[2..-1];
  P := map([$1..P[-1]],
          expo -> if contains(P, expo)>0 then
                    P[contains(P, expo)-1]
                  else
                    poly(1, op(p, 2))
                  end_if);
  S := map(P, pi -> gcd(pi, intlib::algebraic::diff(ts, diffs, algs)(pi)));
  N := zip(P, S, (a, b) -> divide(a, b, Quo)); // Exact division
  N[1] := multcoeffs(N[1], const);
  [N, S];
end:
