// 

// definite integration involving abs(something real)
// or surd(something real, whatever) or sign(sth real)
// this works only if there are only a finite number
// of places where the arguments of abs are zero

intlib::defInt_abs :=
proc(f, x, a, b, options)
  local indices, exs, critpts, res, i, j,
	t, dt, subex, subex2, rnd;
begin
  if {domtype(float(a)), domtype(float(b))} <> {DOM_FLOAT} then
    return(FAIL);
  end_if;
  
  save x;
  // extract all expressions appearing as arguments
  // of abs and involving x
  indices := select(map([prog::find(f, hold(abs)),
                         prog::find(f, hold(surd)),
                         prog::find(f, hold(sign))],
			l -> l[1..-2]),
		    l -> has(op(f, l.[1]), x));

  exs := {op(map(indices, l->op(f, l.[1])))};
  
  // use solve to try and find the critical points
  // where these expressions are integers
  critpts := {};
  for i in exs do
    if discont(i, x) <> {} then
      return(FAIL);
    end_if;
  // ensure there are no (hidden?) complex numbers
    if is(i, Type::Real) <> TRUE or
       traperror((t := solve(i, x, if options[IgnoreAnalyticConstraints]=TRUE then IgnoreAnalyticConstraints end_if))) <> 0 or
       domtype(t) <> DOM_SET or
       traperror((dt := intlib::discont(i, x = a..b))) <> 0 or
       domtype(dt) <> DOM_SET then
      return(intlib::defInt_abs2(args()));
    end_if;
    critpts := critpts union t union dt;
  end_for;
  
  // to reach subexpressions first
  indices := prog::sort(indices, -nops);
  
  // critical points in numerical order
  if map(critpts, domtype@float) <> {DOM_FLOAT} then
    return(FAIL);
  end_if;
  critpts := select(critpts, x0 -> (is(a < x0) and is(x0 < b)) = TRUE);
  critpts := prog::sort([op(critpts union {a, b})], float);
  
  // between each two of these, the abs() are replaceable
  // by + or -.  we try to compute which one
  res := 0;
  rnd := frandom(129876);
  for i from 1 to nops(critpts) - 1 do
    assume(critpts[i]<x<critpts[i+1]);
    t := f;
    for j in indices do
      subex := intlib::Simplify(op(f, j), options, Steps=25);
      if op(subex, 0) = hold(abs) then
        subex2 := intlib::Simplify(subs(op(subex),
          x=float(critpts[i]+rnd()*(critpts[i+1]-critpts[i]))), options, Steps=15);
        if is(subex2 >= 0)=TRUE then
          subex := op(subex);
        elif is(subex2 <= 0)=TRUE then
          subex := -op(subex);
        end;
      elif op(subex, 0) = hold(sign) then
        subex2 := intlib::Simplify(subs(op(subex),
          x=float(critpts[i]+rnd()*(critpts[i+1]-critpts[i]))), options, Steps=15);
        if is(subex2 > 0)=TRUE then
          subex := 1;
        elif is(subex2 < 0)=TRUE then
          subex := -1;
        end;
      end_if;
      t := subsop(t, j=subex, Unsimplified);
    end_for;
    res := res + intlib::defInt(eval(t), x=critpts[i]..critpts[i+1], options);
  end_for;
  res;
end_proc:

intlib::defInt_abs2 :=
proc(f, x, a, b, options)
  local res;
begin
  save x;
  assume(a<x<b);
  res := FAIL;
//  if traperror((res := expr(rectform(intlib::Simplify(f, options)))),
  if traperror((res := expr(rectform(f))),
		MaxSteps=intlib::simplifyMaxSteps(f, f, abs)) = 0 and
     expr(res) <> f then
    return(intlib::defInt(res,x=a..b, options));
  end;
  FAIL;
end:
