// 

// definite integration involving ceil, floor, round
// this works only if there are only a finite number
// of places where the arguments of ceil and floor
// are integral or where the args of round are
// integer+1/2.

intlib::defInt_ceil_floor :=
proc(f, x, a, b, options)
  local indices, indices_round, exs, critpts, res, i, j, k,
	t, dt, subex, subex_x0, rnd, indices_heaviside;
begin
  // extract all expressions appearing as arguments
  // of ceil/floor and involving x
  indices := select(map([prog::find(f, hold(ceil))].
			[prog::find(f, hold(floor))],
			l -> l[1..-2]),
		    l -> has(op(f, l.[1]), x));
  indices_round := select(map([prog::find(f, hold(round))],
			      l -> l[1..-2]),
			  l -> has(op(f, l.[1]), x));
  indices_heaviside := select(map([prog::find(f, hold(heaviside))],
				  l -> l[1..-2]),
			      l -> has(op(f, l.[1]), x));
  exs := {op(map(indices, l->op(f, l.[1])))};
  
  // use solve to try and find the critical points
  // where these expressions are integers
  critpts := {};
  for i in exs do
  // ensure there are no (hidden?) complex numbers
    if not is(i in R_, Goal = TRUE) or
       discont(i, x) <> {} or
       traperror((t := solvelib::preImage(i, x, Z_))) <> 0 or
       domtype(t) <> DOM_SET or
       traperror((dt := intlib::discont(i, x= a..b))) <> 0 or
       domtype(dt) <> DOM_SET then
      return(FAIL);
    end_if;
    critpts := critpts union t union dt;
  end_for;
  
  // now, the same for round
  exs := {op(map(indices_round, l->op(f, l.[1])))};
  
  // use solve to try and find the critical points
  // where these expressions are integers + 1/2
  for i in exs do
    if not is(i in R_, Goal = TRUE) or
       traperror((t := solvelib::preImage(i - 1/2, x, Z_))) <> 0 or
       domtype(t) <> DOM_SET or
       traperror((dt := intlib::discont(i, x = a..b))) <> 0 or
       domtype(dt) <> DOM_SET then
      return(FAIL);
    end_if;
    critpts := critpts union t union dt;
  end_for;
  
  // And now for heaviside
  exs := {op(map(indices_heaviside, l->op(f, l.[1])))};
  
  // use solve to try and find the critical points
  // where these expressions are integers + 1/2
  for i in exs do
    if not is(i in R_, Goal = TRUE) or
       traperror((t := solvelib::preImage(i, x, {0}))) <> 0 or
       domtype(t) <> DOM_SET or
       traperror((dt := intlib::discont(i, x = a..b))) <> 0 or
       domtype(dt) <> DOM_SET then
      return(FAIL);
    end_if;
    critpts := critpts union t union dt;
  end_for;
  
  // to reach subexpressions first
  indices := prog::sort(indices.indices_round.indices_heaviside, -nops);
  
  // critical points in numerical order
  critpts := select(critpts, x0 -> (is(a < x0) and is(x0 < b)) = TRUE);
  critpts := prog::sort([op(critpts union {a, b})], float);
  
  // between each two of these, the ceil/floor/round is constant;
  // we try to compute it.  The additional round is neccessary
  // for heaviside, since heaviside(3.1)=1.0, for whatever reason.
  res := 0;
  rnd := frandom(129876);
  for i from 1 to nops(critpts) - 1 do
    t := f;
    for j in indices do
      subex := op(f, j);
      if not type(subex) in {"ceil", "floor", "round", "heaviside"}
      then next; end;
      subex_x0 := map({rnd() $ k = 1..5},
		      x0 -> round(subex
				  | x = (1-x0)*critpts[i] + x0*critpts[i+1]));
      if nops(subex_x0) = 1 then
        t := subs(t, subex=op(subex_x0, 1));
      end_if;
    end_for;
    res := res + intlib::defInt(t, x=critpts[i]..critpts[i+1], options);
  end_for;
  res;
end_proc:
