// TODO: Generate specialized FSAs for expressions containing certain special functions

// Ausführen in INTLIB/DEFINITE um patternFSA.mb zu erzeugen
//
//       and for common intervals of integration
// Globale Annahmen:
// Integrationsvariable x
// a, b, c, ..., v, w, y, z  sind von x unabhängig
// m, n, m0, n0 positiv und ganzzahlig
// m2, n2 positiv, ganzzahlig, gerade
// m1, n1 positiv, ganzzahlig, ungerade
// m3, n3 ganzzahlig
// mp1 = m+1
// m_ = -m, n_ = -n, m0_ = -m0, n0_ = -n0
// fx, gx, f1x, g1x are unrestricted
// px, qx are polynomial expressions
// qx1 is the reciprocal of a polynomial expression

default_assumptions :=
map([a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,y,z],
  v -> subs(matchlib::block(not has(#v, _X_)), #v=v)) .
map([m, mp1, n, m0, n0, m1, m2, n1, n2],
    v -> subs(matchlib::block(#v in Z_ and #v>0), #v=v)).
[matchlib::block(m2 in 2*Z_),     
 matchlib::block(n2 in 2*Z_),    
 matchlib::block(m1 in 2*Z_+1),     
 matchlib::block(n1 in 2*Z_+1),     
 matchlib::block(n3 in Z_), 
 matchlib::block(m3 in Z_), 
 mp1 = m+1,
 matchlib::block(testtype(px, Type::PolyExpr([_X_], Type::IndepOf(_X_)))),
 matchlib::block(testtype(qx, Type::PolyExpr([_X_], Type::IndepOf(_X_)))),
 matchlib::block(testtype(1/qx1, Type::PolyExpr([_X_], Type::IndepOf(_X_)))),
 null()
]:

assumptions :=
proc(pattern)
  local vars;
begin
  vars := indets(pattern) union Type::ConstantIdents union stdlib::PROTECTED union {_X_, `#matchlib::block`};
  select(default_assumptions,
         a->indets(a) minus vars = {});
end:

include_assumptions :=
proc(p)
begin
  [p[1], p[2],
//   [op(indets(p) minus (Type::ConstantIdents union stdlib::PROTECTED union {_X_, `#matchlib::block`}))],
   if nops(p) = 3 then
     p[3]
   else
     []
   end_if.
   assumptions(p[1])];
end_proc:

// here, the vars have not been renamed yet
extractconstants :=
proc(pat)
  local pat1, noX, dummy;
begin
  if type(pat[1]) = "_mult" then
    [pat1, noX, dummy] := split([op(pat[1])],
                                has, hold([x, fx, gx, f1x, g1x, px, qx, qx1]));
    noX := _mult(op(noX));
    if noX <> 1 then
      [_mult(op(pat1)),
       subs(matchlib::block(#a/#b),
            #a=matchlib::unblock(pat[2]),
            #b=noX),
       if nops(pat)>2 then
         pat[3]
       else
         null()
       end_if];
    else
      pat;
    end_if;
  else
    pat
  end_if;
end_proc:

LEVEL := 1: // spart Zeit beim Einlesen

read("patterns_definite.mu"):

// defint_patterns := select(defint_patterns, has, [f1]):

print (Unquoted, "Read ".expr2text(nops(defint_patterns)
            +nops(cauchy_patterns))." patterns"):

// check for errors happening often:
boundIndets :=
proc(ex)
  local poss, pos, res;
begin
  poss := {prog::find(ex, hold(sum)),
    prog::find(ex, hold(product)),
    prog::find(ex, hold(int))};
  res := {};
  for pos in poss do
    res := res union {op(ex, pos[1..-2].[2,1])};
  end_for;
  res;
end_proc:

for pat in defint_patterns.cauchy_patterns do
  if domtype(pat) <> DOM_LIST then
    error("Not a list: ".expr2text(pat));
  end_if;
  if nops(pat) > 2 then
    if domtype(pat[3]) <> DOM_LIST then
      error("illegal conditions at ".expr2text(pat[1]));
    end_if;
  end_if;
  if select(indets(pat[2]) minus indets(pat[1]) 
      minus boundIndets(pat[2]) minus {x, u, v, `#matchlib::block`} minus stdlib::OPTIONS
    minus Type::ConstantIdents, i -> i = eval(i)) <> {} then
    error("result contains more indets than pattern: ".expr2text(pat));
  end_if;
  if select(freeIndets(pat[3]) minus indets(pat[1]) 
      minus {x, u, v, `#matchlib::block`} minus stdlib::OPTIONS
    minus Type::ConstantIdents, i -> i = eval(i)) <> {} then
    error("condition contains more indets than pattern: ".expr2text(pat));
  end_if;
end_for:


// constant factors
int_patterns2 := subs(map(defint_patterns, extractconstants), x=_X_):
cauchy_patterns2 := subs(map(cauchy_patterns, extractconstants), x=_X_):

if Pref::userOptions()="showPatterns" then
// debugging help
for i from 1 to nops(int_patterns2) do
  if matchlib::isBlock(int_patterns2[i][2]) then
    int_patterns2[i][2][2] := int_patterns2[i][2][2]+(#pattern(i));
  else
    int_patterns2[i][2] := int_patterns2[i][2]+(#pattern(i));
  end_if;
end_for:
end_if:

int_patterns2 := map(int_patterns2,
  proc(p)
    local pat, pat2;
    name alsoIncludeSimplifiedVersionOfInput;
  begin
    pat := p[1];
    pat2 := intlib::Simplify(pat);
    if pat = pat2 then
      p
    else
      p, subsop(p, 1=pat2)
    end_if;
  end_proc):

doTransform :=
    proc(p)
      local l, r;
    begin
      p[1] := `#defint`(p[1], u, v);
      l := select(p[3], eq -> _lazy_and(type(eq)="_equal", lhs(eq)=u));
      if nops(l) = 1 then
        p[3] := select(p[3], `<>`, l[1]);
        l := rhs(l[1])
      else
        l := u;
      end;
      r := select(p[3], eq -> _lazy_and(type(eq)="_equal", lhs(eq)=v));
      if nops(r) = 1 then
        p[3] := select(p[3], `<>`, r[1]);
        r := rhs(r[1])
      else
        r := v;
      end;
      p[2]:= [p[2], _X_, l, r];
      p;
    end:

int_patterns2 := map(int_patterns2, include_assumptions @ doTransform):
cauchy_patterns2 := map(cauchy_patterns2, include_assumptions @ doTransform):


/*
allpatterns := []:

matchlib::addpatterns(intlib::definite::patternFSA, allpatterns, int_patterns2,
	                  intlib::definite::generalize, 50, 
                      [[RatExpr, ex -> testtype(subs(ex[1], `##`(`#f(_X_)`)=_X_), 
	                          Type::Rational(_X_, Type::IndepOf(_X_)))],
                       "sin", "cos", "ln", "tan",
                       "arctan", "sinh", "cosh",
                       "exp", "arcsin", "arccos",
                       "arcsinh", "arccosh", "arccot"]):
allcauchypatterns := []:

matchlib::addpatterns(intlib::definite::patternFSA_Cauchy, 
                          allcauchypatterns, cauchy_patterns2,
	                  intlib::definite::generalize, 50, 
                      [[RatExpr, ex -> testtype(subs(ex[1], `##`(`#f(_X_)`)=_X_), 
	                          Type::Rational(_X_, Type::IndepOf(_X_)))],
                       "sin", "cos", "ln", "tan",
                       "arctan", "sinh", "cosh",
                       "exp", "arcsin", "arccos",
                       "arcsinh", "arccosh", "arccot"]):

if Pref::userOptions()<>"showPatterns" then
  FSA_cauchy := intlib::definite::patternFSA_Cauchy:
  FSA := intlib::definite::patternFSA:
  write("patternFSA.mb", FSA, FSA_cauchy):
end_if:

*/

unprotect(intlib):
intlib::definite::patterns := matchlib::einwohner::compile(int_patterns2, _X_):
intlib::definite::cauchy_patterns := matchlib::einwohner::compile(cauchy_patterns2, _X_):
protect(intlib, ProtectLevelError):

if Pref::userOptions()<>"showPatterns" and doNotSavePatterns <> TRUE then
  cauchy_patterns := intlib::definite::cauchy_patterns;
  patterns := intlib::definite::patterns;
  write("patterns_bin.mb", patterns, cauchy_patterns);
end_if:


