/* intlib::defLookup(f,t=a..b,options) computes int(f,t=a..b,options),
  and return FAIL if unable.
   References:

   [1] Evaluation of Classes of Definite Integrals Involving
   Elementary Functions via Differentiation of Special Functions,
   by K.O. Geddes, M.L. Glasser, R.A. Moore and T.C. Scott,
   Applicable Algebra in Engineering, Communication and Computing (AAECC)
   volume 1, pages 149-165, 1990.

   [2] Explicit Evaluation of Certain Definite Integrals Involving
       Powers of Logarithms, by K.S. Klbig, JSC 1, 1985, pages 109-114.

   The implementation here first checks for the classes in [1], and then
   uses the formulas in [2] for the special cases not treated in [1].
   All the examples given in [2] (4.1 to 4.9) work.

   Currently only the first two classes in [1] are implemented. The third
   class (generated by the incomplete gamma function) needs the
   Meijer G function, which is not yet implemented in MuPAD.
*/

alias(indep(a,x)=_pattern(hold(a),not has,x)): /* NOTE: same alias is
                                                   defined in lookup.mu */
alias(_p=_pattern):

/* first class of integrals (generated by the gamma function),
   recognizes int(t^w*ln(b*t^d)^m*exp(-u*t^s)*cos(c*t^s),t=0..infinity)
   where the cos can be replaced by sin, formula (3) p. 151
*/
intlib::intdef1 :=
proc(typ, w, b, d, m, u, _s, c)
  local fac,i,a,integral;
begin
   fac := 1;
   
   if is(_s,Type::Real, Goal=FALSE)<>TRUE or is(b>0 or m=0, Goal=FALSE) <> TRUE then FAIL
   elif _s=0 or is(u>0, Goal=FALSE)<>TRUE then (
        if u=0 and m=0 and typ="cos" then
           if is(w<=-1, Goal=TRUE) then infinity
           elif w=0 and is(c>0, Goal=TRUE) then
             if _s=1 then undefined
             elif is(_s>1, Goal=TRUE) then // Gradsteyn, Ryzhik: 3.712
               cos(PI/2/_s)*gamma(1/_s)/abs(c)^(1/_s)/_s
             else FAIL end_if
           else FAIL end_if
        elif u=0 and m=0 and typ="sin" and w=0 and is(c>0, Goal=TRUE) then
           if _s=1 then undefined
           elif is(_s>1, Goal=TRUE) then // Gradsteyn, Ryzhik: 3.712
             sin(PI/2/_s)*gamma(1/_s)/abs(c)^(1/_s)/_s*sign(c)
           else FAIL end_if
        else FAIL end_if )
   else
      a:=(w+1)/_s;
      if is(Re(a)>0, Goal=FALSE)<>TRUE then
         if a=0 and m=0 and typ="sin" then return(arctan(c/u)/_s) end_if;
         return(FAIL)
      end_if;
      u:=u-I*c;
      // change of variable u*t^s -> t^s
      fac:=u^(-a);
      b:=b*u^(-d/_s);
      // now the integrand is fac*t^w*ln(b*t^d)^m*exp(-t^s)
      // and arg(t)=arg(u).
      if is(u>0, Goal=TRUE) or d=1 then
        // formula (1) and (2) page 151
        integral:=fac*sign(_s)*_plus(binomial(m,i)*ln(b)^(m-i)*d^i*_s^(-i-1)*
           eval(D([1$i], gamma)(a)) $ i=0..m);
      else
        return(FAIL);
      end_if;
      if typ="cos" then Re(integral)
      elif typ="sin" then Im(integral)
      else integral
      end_if;
   end_if;
end_proc:

